/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.util;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class Debug {
    static final String className = ClientComms.class.getName();
    Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", className);
    static String separator = "==============";
    static String lineSep = System.getProperty("line.separator", "\n");
    String clientID;
    ClientComms comms;

    public Debug(String clientID, ClientComms comms) {
        this.clientID = clientID;
        this.comms = comms;
        this.log.setResourceName(clientID);
    }

    public void dumpClientDebug() {
        this.dumpClientComms();
        this.dumpConOptions();
        this.dumpClientState();
        this.dumpBaseDebug();
    }

    public void dumpBaseDebug() {
        this.dumpVersion();
        this.dumpSystemProperties();
        this.dumpMemoryTrace();
    }

    protected void dumpMemoryTrace() {
        this.log.dumpTrace();
    }

    protected void dumpVersion() {
        StringBuffer vInfo = new StringBuffer();
        vInfo.append(lineSep + separator + " Version Info " + separator + lineSep);
        vInfo.append(Debug.left("Version", 20, ' ') + ":  " + ClientComms.VERSION + lineSep);
        vInfo.append(Debug.left("Build Level", 20, ' ') + ":  " + ClientComms.BUILD_LEVEL + lineSep);
        vInfo.append(separator + separator + separator + lineSep);
        this.log.fine(className, "dumpVersion", vInfo.toString());
    }

    public void dumpSystemProperties() {
        Properties sysProps = System.getProperties();
        this.log.fine(className, "dumpSystemProperties", Debug.dumpProperties(sysProps, "SystemProperties").toString());
    }

    public void dumpClientState() {
        Properties props = null;
        if (this.comms != null && this.comms.getClientState() != null) {
            props = this.comms.getClientState().getDebug();
            this.log.fine(className, "dumpClientState", Debug.dumpProperties(props, this.clientID + " : ClientState").toString());
        }
    }

    public void dumpClientComms() {
        Properties props = null;
        if (this.comms != null) {
            props = this.comms.getDebug();
            this.log.fine(className, "dumpClientComms", Debug.dumpProperties(props, this.clientID + " : ClientComms").toString());
        }
    }

    public void dumpConOptions() {
        Properties props = null;
        if (this.comms != null) {
            props = this.comms.getConOptions().getDebug();
            this.log.fine(className, "dumpConOptions", Debug.dumpProperties(props, this.clientID + " : Connect Options").toString());
        }
    }

    public static String dumpProperties(Properties props, String name) {
        StringBuffer propStr = new StringBuffer();
        Enumeration<?> propsE = props.propertyNames();
        propStr.append(lineSep + separator + " " + name + " " + separator + lineSep);
        while (propsE.hasMoreElements()) {
            String key = (String)propsE.nextElement();
            propStr.append(Debug.left(key, 28, ' ') + ":  " + props.get(key) + lineSep);
        }
        propStr.append(separator + separator + separator + lineSep);
        return propStr.toString();
    }

    public static String left(String s, int width, char fillChar) {
        if (s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        sb.append(s);
        int i = width - s.length();
        while (--i >= 0) {
            sb.append(fillChar);
        }
        return sb.toString();
    }
}

