/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client;

import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.mqttv5.client.IMqttClient;
import org.eclipse.paho.mqttv5.client.IMqttMessageListener;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttTopic;
import org.eclipse.paho.mqttv5.client.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.mqttv5.client.util.Debug;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttPersistenceException;
import org.eclipse.paho.mqttv5.common.MqttSecurityException;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;

public class MqttClient
implements IMqttClient {
    protected MqttAsyncClient aClient = null;
    protected long timeToWait = -1L;

    public MqttClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this.aClient = new MqttAsyncClient(serverURI, clientId, persistence);
    }

    public MqttClient(String serverURI, String clientId, MqttClientPersistence persistence, ScheduledExecutorService executorService) throws MqttException {
        this.aClient = new MqttAsyncClient(serverURI, clientId, persistence, null, executorService);
    }

    @Override
    public void connect() throws MqttSecurityException, MqttException {
        this.connect(new MqttConnectionOptions());
    }

    @Override
    public void connect(MqttConnectionOptions options) throws MqttSecurityException, MqttException {
        this.aClient.connect(options, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public IMqttToken connectWithResult(MqttConnectionOptions options) throws MqttSecurityException, MqttException {
        IMqttToken tok = this.aClient.connect(options, null, null);
        tok.waitForCompletion(this.getTimeToWait());
        return tok;
    }

    @Override
    public void disconnect() throws MqttException {
        this.aClient.disconnect().waitForCompletion();
    }

    @Override
    public void disconnect(long quiesceTimeout) throws MqttException {
        this.aClient.disconnect(quiesceTimeout, null, null, 0, new MqttProperties()).waitForCompletion();
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.aClient.disconnectForcibly();
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.aClient.disconnectForcibly(disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.aClient.disconnectForcibly(quiesceTimeout, disconnectTimeout, 0, new MqttProperties());
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, boolean sendDisconnectPacket) throws MqttException {
        this.aClient.disconnectForcibly(quiesceTimeout, disconnectTimeout, sendDisconnectPacket);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos});
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos) throws MqttException {
        if (topicFilters.length != qos.length) {
            throw new MqttException(6);
        }
        MqttSubscription[] subscriptions = new MqttSubscription[topicFilters.length];
        int i = 0;
        while (i < topicFilters.length) {
            subscriptions[i] = new MqttSubscription(topicFilters[i], qos[i]);
            ++i;
        }
        return this.subscribe(subscriptions);
    }

    public IMqttToken subscribe(MqttSubscription[] subscriptions) throws MqttException {
        return this.subscribe(subscriptions, null);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, IMqttMessageListener[] messageListeners) throws MqttException {
        return this.subscribe(topicFilters, qos, messageListeners);
    }

    public IMqttToken subscribe(MqttSubscription[] subscriptions, IMqttMessageListener[] messageListeners) throws MqttException {
        IMqttToken tok = this.aClient.subscribe(subscriptions, null, null, messageListeners, new MqttProperties());
        tok.waitForCompletion(this.getTimeToWait());
        return tok;
    }

    @Override
    public void unsubscribe(String topicFilter) throws MqttException {
        this.unsubscribe(new String[]{topicFilter});
    }

    @Override
    public void unsubscribe(String[] topicFilters) throws MqttException {
        this.aClient.unsubscribe(topicFilters, null, null, new MqttProperties()).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public void publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        this.publish(topic, message);
    }

    @Override
    public void publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        this.aClient.publish(topic, message, null, null).waitForCompletion(this.getTimeToWait());
    }

    public void setTimeToWait(long timeToWaitInMillis) throws IllegalArgumentException {
        if (timeToWaitInMillis < -1L) {
            throw new IllegalArgumentException();
        }
        this.timeToWait = timeToWaitInMillis;
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    @Override
    public void close() throws MqttException {
        this.aClient.close(false);
    }

    public void close(boolean force) throws MqttException {
        this.aClient.close(force);
    }

    @Override
    public String getClientId() {
        return this.aClient.getClientId();
    }

    @Override
    public IMqttToken[] getPendingTokens() {
        return this.aClient.getPendingTokens();
    }

    @Override
    public String getServerURI() {
        return this.aClient.getServerURI();
    }

    public String getCurrentServerURI() {
        return this.aClient.getCurrentServerURI();
    }

    @Override
    public MqttTopic getTopic(String topic) {
        return this.aClient.getTopic(topic);
    }

    @Override
    public boolean isConnected() {
        return this.aClient.isConnected();
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.aClient.setCallback(callback);
    }

    @Override
    public void setManualAcks(boolean manualAcks) {
        this.aClient.setManualAcks(manualAcks);
    }

    @Override
    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.aClient.messageArrivedComplete(messageId, qos);
    }

    @Override
    public void reconnect() throws MqttException {
        this.aClient.reconnect();
    }

    public Debug getDebug() {
        return this.aClient.getDebug();
    }
}

