/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorSelector;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.helper.MavenPropertyHelper;

@Component(role=IProvisioningAgent.class)
public class DefaultProvisioningAgent
implements IProvisioningAgent {
    @Requirement
    private Logger log;
    @Requirement(hint="connect")
    private EquinoxServiceFactory serviceFactory;
    @Requirement
    private PlexusContainer plexusContainer;
    @Requirement
    Map<String, IAgentServiceFactory> agentFactories;
    @Requirement
    MavenPropertyHelper propertyHelper;
    private Map<String, Supplier<Object>> agentServices = new ConcurrentHashMap<String, Supplier<Object>>();

    public Object getService(String serviceName) {
        Object agentService = this.getOSGiAgentService(serviceName);
        if (agentService != null) {
            return agentService;
        }
        this.log.debug("Service " + serviceName + " not found in OSGi ProvisioningAgent agent, look it up in Plexus AgentServiceFactories");
        Object factoryService = this.getAgentFactoryService(serviceName);
        if (factoryService != null) {
            return factoryService;
        }
        this.log.debug("Service " + serviceName + " not found in Plexus AgentServiceFactories, look it up in Plexus Container");
        try {
            return this.plexusContainer.lookup(serviceName);
        }
        catch (ComponentLookupException e) {
            this.log.debug("Service " + serviceName + " was not found in PlexusContainer");
            this.log.warn("Cannot locate service " + serviceName + " because no provisioning agent was found");
            return null;
        }
    }

    private synchronized Object getAgentFactoryService(String serviceName) {
        return this.agentServices.computeIfAbsent(serviceName, key -> {
            IAgentServiceFactory factory = this.agentFactories.get(key);
            if (factory != null) {
                return new LazyAgentServiceFactory(factory, this);
            }
            return () -> null;
        }).get();
    }

    private Object getOSGiAgentService(String serviceName) {
        IProvisioningAgent agent = (IProvisioningAgent)this.serviceFactory.getService(IProvisioningAgent.class);
        if (agent != null) {
            return agent.getService(serviceName);
        }
        return null;
    }

    public void registerService(String serviceName, Object service) {
        IProvisioningAgent agent = (IProvisioningAgent)this.serviceFactory.getService(IProvisioningAgent.class);
        if (agent != null) {
            agent.registerService(serviceName, service);
        }
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void unregisterService(String serviceName, Object service) {
        IProvisioningAgent agent = (IProvisioningAgent)this.serviceFactory.getService(IProvisioningAgent.class);
        if (agent != null) {
            agent.unregisterService(serviceName, service);
        }
    }

    public String getProperty(String key, String defaultValue) {
        return this.propertyHelper.getGlobalProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.propertyHelper.getGlobalProperty(key);
    }

    static {
        MirrorSelector.MIRROR_PARSE_ERROR_LEVEL = 1;
        String atomicDefaultSystemProperty = "eclipse.p2.atomic.composite.loading.default";
        if (System.getProperty(atomicDefaultSystemProperty) == null) {
            System.setProperty(atomicDefaultSystemProperty, Boolean.toString(true));
        }
    }

    private static final class LazyAgentServiceFactory
    implements Supplier<Object> {
        private IAgentServiceFactory factory;
        private IProvisioningAgent agent;
        private Object service;

        LazyAgentServiceFactory(IAgentServiceFactory factory, IProvisioningAgent agent) {
            this.factory = factory;
            this.agent = agent;
        }

        @Override
        public synchronized Object get() {
            if (this.service == null && this.factory != null && this.agent != null) {
                IAgentServiceFactory agentServiceFactory = this.factory;
                IProvisioningAgent provisioningAgent = this.agent;
                this.factory = null;
                this.agent = null;
                this.service = agentServiceFactory.createService(provisioningAgent);
            }
            return this.service;
        }
    }
}

