/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleArtifactRepositoryIO {
    public void write(SimpleArtifactRepository repository, OutputStream output) {
        try (BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);){
            Writer repositoryWriter = new Writer(bufferedOutput);
            repositoryWriter.write(repository);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public IArtifactRepository read(URL location, InputStream input) throws ProvisionException {
        SimpleArtifactRepository simpleArtifactRepository;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        try {
            Parser repositoryParser = new Parser("org.eclipse.equinox.p2.artifact.repository");
            repositoryParser.parse(input);
            IStatus result = repositoryParser.getStatus();
            switch (result.getSeverity()) {
                case 8: {
                    throw new OperationCanceledException();
                }
                case 4: {
                    throw new ProvisionException(result);
                }
                case 1: 
                case 2: {
                    LogHelper.log((IStatus)result);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown serverity value: " + result.getSeverity());
                }
            }
            SimpleArtifactRepository repository = repositoryParser.getRepository();
            if (repository == null) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1002, Messages.io_parseError, null));
            }
            simpleArtifactRepository = repository;
        }
        catch (Throwable repositoryParser) {
            try {
                try {
                    bufferedInput.close();
                }
                catch (Throwable throwable) {
                    repositoryParser.addSuppressed(throwable);
                }
                throw repositoryParser;
            }
            catch (IOException ioe) {
                String msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1002, msg, (Throwable)ioe));
            }
        }
        bufferedInput.close();
        return simpleArtifactRepository;
    }

    public static class Writer
    extends XMLWriter
    implements XMLConstants {
        public static XMLWriter.ProcessingInstruction[] PI_DEFAULTS = new XMLWriter.ProcessingInstruction[]{XMLWriter.ProcessingInstruction.makeTargetVersionInstruction((String)"artifactRepository", (Version)CURRENT_VERSION)};

        public Writer(OutputStream output) throws IOException {
            super(output, PI_DEFAULTS);
        }

        public void write(SimpleArtifactRepository repository) {
            this.start("repository");
            this.attribute("name", repository.getName());
            this.attribute("type", repository.getType());
            this.attribute("version", repository.getVersion());
            this.attributeOptional("provider", repository.getProvider());
            this.attributeOptional("description", repository.getDescription());
            this.writeProperties(repository.getProperties());
            this.writeMappingRules(repository.getRules());
            this.writeArtifacts(repository.getDescriptors());
            this.end("repository");
            this.flush();
        }

        private void writeMappingRules(String[][] rules) {
            if (rules.length > 0) {
                this.start("mappings");
                this.attribute("size", rules.length);
                for (String[] rule : rules) {
                    this.start("rule");
                    this.attribute("filter", rule[0]);
                    this.attribute("output", rule[1]);
                    this.end("rule");
                }
                this.end("mappings");
            }
        }

        protected void writeArtifacts(Set<? extends IArtifactDescriptor> artifactDescriptors) {
            this.start("artifacts");
            this.attribute("size", artifactDescriptors.size());
            for (IArtifactDescriptor iArtifactDescriptor : artifactDescriptors) {
                IArtifactKey key = iArtifactDescriptor.getArtifactKey();
                this.start("artifact");
                this.attribute("classifier", key.getClassifier());
                this.attribute("id", key.getId());
                this.attribute("version", key.getVersion());
                this.writeProcessingSteps(iArtifactDescriptor.getProcessingSteps());
                this.writeProperties(iArtifactDescriptor.getProperties());
                this.end("artifact");
            }
            this.end("artifacts");
        }

        private void writeProcessingSteps(IProcessingStepDescriptor[] processingSteps) {
            if (processingSteps.length > 0) {
                this.start("processing");
                this.attribute("size", processingSteps.length);
                for (IProcessingStepDescriptor processingStep : processingSteps) {
                    this.start("step");
                    this.attribute("id", processingStep.getProcessorId());
                    this.attribute("data", processingStep.getData());
                    this.attribute("required", processingStep.isRequired());
                    this.end("step");
                }
                this.end("processing");
            }
        }
    }

    public static class Parser
    extends XMLParser
    implements XMLConstants {
        private SimpleArtifactRepository theRepository = null;

        public Parser(String bundleId) {
            super(bundleId);
        }

        public synchronized void parse(InputStream stream) throws IOException {
            this.status = null;
            try {
                this.getParser();
                RepositoryHandler repositoryHandler = new RepositoryHandler();
                this.xmlReader.setContentHandler((ContentHandler)((Object)new RepositoryDocHandler("repository", repositoryHandler)));
                this.xmlReader.parse(new InputSource(stream));
                if (this.isValidXML()) {
                    this.theRepository = repositoryHandler.getRepository();
                }
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                stream.close();
            }
        }

        public SimpleArtifactRepository getRepository() {
            return this.theRepository;
        }

        protected Object getRootObject() {
            return this.theRepository;
        }

        protected String getErrorMessage() {
            return Messages.io_parseError;
        }

        private final class RepositoryHandler
        extends XMLParser.RootHandler {
            private final String[] required;
            private final String[] optional;
            private String[] attrValues;
            private MappingRulesHandler mappingRulesHandler;
            private XMLParser.PropertiesHandler propertiesHandler;
            private ArtifactsHandler artifactsHandler;

            public RepositoryHandler() {
                super((XMLParser)Parser.this);
                this.required = new String[]{"name", "type", "version"};
                this.optional = new String[]{"description", "provider"};
                this.attrValues = new String[this.required.length + this.optional.length];
                this.mappingRulesHandler = null;
                this.propertiesHandler = null;
                this.artifactsHandler = null;
            }

            public SimpleArtifactRepository getRepository() {
                return null;
            }

            protected void handleRootAttributes(Attributes attributes) {
                this.attrValues = this.parseAttributes(attributes, this.required, this.optional);
                this.attrValues[2] = Parser.this.checkVersion("repository", "version", this.attrValues[2]).toString();
            }

            public void startElement(String name, Attributes attributes) {
                if ("mappings".equals(name)) {
                    if (this.mappingRulesHandler == null) {
                        this.mappingRulesHandler = new MappingRulesHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else if ("artifacts".equals(name)) {
                    if (this.artifactsHandler == null) {
                        this.artifactsHandler = new ArtifactsHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else if ("properties".equals(name)) {
                    if (this.propertiesHandler == null) {
                        this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected final class RepositoryDocHandler
        extends XMLParser.DocHandler {
            public RepositoryDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)Parser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                Version repositoryVersion;
                if ("artifactRepository".equals(target) && !XMLConstants.XML_TOLERANCE.isIncluded(repositoryVersion = Parser.this.extractPIVersion(target, data))) {
                    throw new SAXException(NLS.bind((String)Messages.io_incompatibleVersion, (Object)repositoryVersion, (Object)XMLConstants.XML_TOLERANCE));
                }
            }
        }

        protected class ProcessingStepHandler
        extends XMLParser.AbstractHandler {
            private final String[] required;
            private final String[] optional;

            public ProcessingStepHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<ProcessingStepDescriptor> processingSteps) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "step");
                this.required = new String[]{"id", "required"};
                this.optional = new String[]{"data"};
                String[] attributeValues = this.parseAttributes(attributes, this.required, this.optional);
                processingSteps.add(new ProcessingStepDescriptor(attributeValues[0], attributeValues[2], Parser.this.checkBoolean("step", "required", attributeValues[1]).booleanValue()));
            }

            public void startElement(String name, Attributes attributes) {
                this.invalidElement(name, attributes);
            }
        }

        protected class ProcessingStepsHandler
        extends XMLParser.AbstractHandler {
            private List<ProcessingStepDescriptor> processingSteps;

            public ProcessingStepsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "processing");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.processingSteps = size != null ? new ArrayList<ProcessingStepDescriptor>(Integer.parseInt(size)) : new ArrayList(4);
            }

            public ProcessingStepDescriptor[] getProcessingSteps() {
                return this.processingSteps.toArray(new ProcessingStepDescriptor[this.processingSteps.size()]);
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("step")) {
                    new ProcessingStepHandler(this, attributes, this.processingSteps);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected class ArtifactHandler
        extends XMLParser.AbstractHandler {
            private final String[] required;
            private Set<IArtifactDescriptor> artifacts;
            ArtifactDescriptor currentArtifact;
            private XMLParser.PropertiesHandler propertiesHandler;
            private XMLParser.PropertiesHandler repositoryPropertiesHandler;
            private ProcessingStepsHandler processingStepsHandler;

            public ArtifactHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, Set<IArtifactDescriptor> artifacts) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "artifact");
                this.required = new String[]{"classifier", "id", "version"};
                this.currentArtifact = null;
                this.propertiesHandler = null;
                this.repositoryPropertiesHandler = null;
                this.processingStepsHandler = null;
                this.artifacts = artifacts;
                String[] values = this.parseRequiredAttributes(attributes, this.required);
                Version version = Parser.this.checkVersion("artifact", "version", values[2]);
                this.currentArtifact = new ArtifactDescriptor((IArtifactKey)new ArtifactKey(values[0], values[1], version));
            }

            public void startElement(String name, Attributes attributes) {
                if ("processing".equals(name)) {
                    if (this.processingStepsHandler == null) {
                        this.processingStepsHandler = new ProcessingStepsHandler(this, attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else if ("properties".equals(name)) {
                    if (this.propertiesHandler == null) {
                        this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else if ("repositoryProperties".equals(name)) {
                    if (this.repositoryPropertiesHandler == null) {
                        this.repositoryPropertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }

            protected void finished() {
                if (Parser.this.isValidXML() && this.currentArtifact != null) {
                    OrderedProperties properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                    this.currentArtifact.addProperties((Map)properties);
                    ProcessingStepDescriptor[] processingSteps = this.processingStepsHandler == null ? new ProcessingStepDescriptor[]{} : this.processingStepsHandler.getProcessingSteps();
                    this.currentArtifact.setProcessingSteps((IProcessingStepDescriptor[])processingSteps);
                    this.artifacts.add((IArtifactDescriptor)this.currentArtifact);
                }
            }
        }

        protected class ArtifactsHandler
        extends XMLParser.AbstractHandler {
            private Set<IArtifactDescriptor> artifacts;

            public ArtifactsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "artifacts");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.artifacts = size != null ? new LinkedHashSet<IArtifactDescriptor>(Integer.parseInt(size)) : new LinkedHashSet(4);
            }

            public Set<IArtifactDescriptor> getArtifacts() {
                return this.artifacts;
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("artifact")) {
                    new ArtifactHandler(this, attributes, this.artifacts);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected class MappingRuleHandler
        extends XMLParser.AbstractHandler {
            private final String[] required;

            public MappingRuleHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<String[]> mappingRules) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "rule");
                this.required = new String[]{"filter", "output"};
                mappingRules.add(this.parseRequiredAttributes(attributes, this.required));
            }

            public void startElement(String name, Attributes attributes) {
                this.invalidElement(name, attributes);
            }
        }

        protected class MappingRulesHandler
        extends XMLParser.AbstractHandler {
            private List<String[]> mappingRules;

            public MappingRulesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)parentHandler, "mappings");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.mappingRules = size != null ? new ArrayList<String[]>(Integer.parseInt(size)) : new ArrayList(4);
            }

            public String[][] getMappingRules() {
                String[][] rules = new String[this.mappingRules.size()][2];
                for (int index = 0; index < this.mappingRules.size(); ++index) {
                    String[] ruleAttributes = this.mappingRules.get(index);
                    rules[index] = ruleAttributes;
                }
                return rules;
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("rule")) {
                    new MappingRuleHandler(this, attributes, this.mappingRules);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }
    }

    private static interface XMLConstants
    extends org.eclipse.equinox.internal.p2.persistence.XMLConstants {
        public static final Version COMPATIBLE_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
        public static final Version CURRENT_VERSION = Version.createOSGi((int)1, (int)1, (int)0);
        public static final VersionRange XML_TOLERANCE = new VersionRange(COMPATIBLE_VERSION, true, Version.createOSGi((int)2, (int)0, (int)0), false);
        public static final String PI_REPOSITORY_TARGET = "artifactRepository";
        public static final String REPOSITORY_ELEMENT = "repository";
        public static final String REPOSITORY_PROPERTIES_ELEMENT = "repositoryProperties";
        public static final String MAPPING_RULES_ELEMENT = "mappings";
        public static final String MAPPING_RULE_ELEMENT = "rule";
        public static final String ARTIFACTS_ELEMENT = "artifacts";
        public static final String ARTIFACT_ELEMENT = "artifact";
        public static final String PROCESSING_STEPS_ELEMENT = "processing";
        public static final String PROCESSING_STEP_ELEMENT = "step";
        public static final String MAPPING_RULE_FILTER_ATTRIBUTE = "filter";
        public static final String MAPPING_RULE_OUTPUT_ATTRIBUTE = "output";
        public static final String ARTIFACT_CLASSIFIER_ATTRIBUTE = "classifier";
        public static final String STEP_DATA_ATTRIBUTE = "data";
        public static final String STEP_REQUIRED_ATTRIBUTE = "required";
    }
}

