/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.tycho.p2maven.transport.Headers;

public interface Response
extends Headers {
    default public void transferTo(OutputStream outputStream) throws IOException {
        String encoding = this.getHeader("Content-Encoding");
        if ("gzip".equals(encoding)) {
            this.transferTo(outputStream, GZIPInputStream::new);
        } else if (encoding == null || encoding.isEmpty() || "identity".equals(encoding)) {
            this.transferTo(outputStream, stream -> stream);
        } else {
            throw new IOException("Unknown content encoding: " + encoding);
        }
    }

    public void transferTo(OutputStream var1, ContentEncoding var2) throws IOException;

    public static interface ContentEncoding {
        public InputStream decode(InputStream var1) throws IOException;
    }

    public static interface ResponseConsumer<T> {
        public T handleResponse(Response var1) throws IOException;
    }
}

