/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.sisu.equinox.launching.BundleReference;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.osgi.framework.Version;

public class DefaultEquinoxInstallationDescription
implements EquinoxInstallationDescription {
    public static final String ANY_QUALIFIER = "qualifier";
    public static final Version EQUINOX_VERSION_3_3_0 = Version.parseVersion((String)"3.3.0");
    public static final String EQUINOX_LAUNCHER = "org.eclipse.equinox.launcher";
    private static final Map<String, BundleStartLevel> DEFAULT_START_LEVEL = new HashMap<String, BundleStartLevel>();
    protected final Map<String, SortedMap<Version, BundleReference>> bundles = new HashMap<String, SortedMap<Version, BundleReference>>();
    private final Map<String, BundleStartLevel> startLevel = new HashMap<String, BundleStartLevel>(DEFAULT_START_LEVEL);
    private BundleStartLevel defaultBundleStartLevel = null;
    private final List<File> frameworkExtensions = new ArrayList<File>();
    private final Set<String> bundlesToExplode = new HashSet<String>();
    private final Map<String, String> platformProperties = new HashMap<String, String>();
    private final Map<String, String> devEntries = new HashMap<String, String>();

    private static void setDefaultStartLevel(String id, int level) {
        DEFAULT_START_LEVEL.put(id, new BundleStartLevel(id, level, true));
    }

    public void addBundleStartLevel(BundleStartLevel level) {
        this.startLevel.put(level.getId(), level);
    }

    public Map<String, BundleStartLevel> getBundleStartLevel() {
        return this.startLevel;
    }

    public BundleStartLevel getDefaultBundleStartLevel() {
        return this.defaultBundleStartLevel;
    }

    public void setDefaultBundleStartLevel(BundleStartLevel defaultBundleStartLevel) {
        this.defaultBundleStartLevel = defaultBundleStartLevel;
    }

    public BundleReference getBundle(String key, String version) {
        SortedMap<Version, BundleReference> map = this.bundles.get(key);
        if (map == null || map.isEmpty()) {
            return null;
        }
        Version parsedVersion = version == null ? Version.emptyVersion : Version.parseVersion((String)version);
        if (Version.emptyVersion.equals((Object)Version.parseVersion((String)version))) {
            return (BundleReference)map.get(map.firstKey());
        }
        String qualifier = parsedVersion.getQualifier();
        if (qualifier == null || qualifier.isBlank() || ANY_QUALIFIER.equals(qualifier)) {
            for (Map.Entry<Version, BundleReference> entry : map.entrySet()) {
                if (!DefaultEquinoxInstallationDescription.baseVersionEquals(parsedVersion, entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return (BundleReference)map.get(parsedVersion);
    }

    private static boolean baseVersionEquals(Version v1, Version v2) {
        return v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v2.getMicro();
    }

    public Collection<BundleReference> getBundles() {
        return this.bundles.values().stream().flatMap(map -> map.values().stream()).toList();
    }

    public BundleReference getSystemBundle() {
        return this.getBundle("org.eclipse.osgi", null);
    }

    public void addBundle(BundleReference reference) {
        if (reference.getLocation() == null) {
            throw new IllegalArgumentException("Location of BundleReference is null");
        }
        this.bundles.computeIfAbsent(reference.getId(), k -> new TreeMap()).put(new Version(reference.getVersion()), reference);
    }

    public void addBundlesToExplode(List<String> bundlesToExplode) {
        this.bundlesToExplode.addAll(bundlesToExplode);
    }

    public Set<String> getBundlesToExplode() {
        return this.bundlesToExplode;
    }

    public void addFrameworkExtensions(List<File> frameworkExtensions) {
        this.frameworkExtensions.addAll(frameworkExtensions);
    }

    public List<File> getFrameworkExtensions() {
        return this.frameworkExtensions;
    }

    public void addPlatformProperty(String property, String value) {
        this.platformProperties.put(property, value);
    }

    public Map<String, String> getPlatformProperties() {
        return this.platformProperties;
    }

    public void addDevEntries(String id, String entries) {
        if (entries != null) {
            this.devEntries.merge(id, entries, (s1, s2) -> s1 + "," + s2);
        }
    }

    public Map<String, String> getDevEntries() {
        return this.devEntries;
    }

    static {
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.equinox.common", 2);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.core.runtime", 4);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.equinox.simpleconfigurator", 1);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.osgi", -1);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.apache.felix.scr", 1);
    }
}

