/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.sisu.equinox.launching.LaunchConfiguration;

public class EquinoxInstallationLaunchConfiguration
implements LaunchConfiguration {
    private static final String EQUINOX_LAUNCHER = "org.eclipse.equinox.launcher_";
    private final File equinoxDirectory;
    private final String[] programArguments;
    private File launcherJar;

    public EquinoxInstallationLaunchConfiguration(File equinoxDirectory, List<String> programArguments) {
        this.equinoxDirectory = equinoxDirectory;
        this.programArguments = programArguments.toArray(new String[0]);
    }

    public static File findLauncherJar(File equinoxDirectory) {
        File pluginsDir = new File(equinoxDirectory, "plugins");
        File[] launchers = pluginsDir.listFiles((dir, name) -> name.startsWith(EQUINOX_LAUNCHER));
        if (launchers == null || launchers.length == 0) {
            final StringBuilder allFiles = new StringBuilder();
            allFiles.append(System.lineSeparator());
            try {
                Files.walkFileTree(equinoxDirectory.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        allFiles.append(dir);
                        allFiles.append(System.lineSeparator());
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        allFiles.append(file);
                        allFiles.append(System.lineSeparator());
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                allFiles.append(e);
            }
            throw new IllegalArgumentException("The launcher bundle org.eclipse.equinox.launcher_*.jar was not found in " + pluginsDir + ", files in directory: \r\n " + allFiles);
        }
        if (launchers.length > 1) {
            throw new IllegalArgumentException("Multiple versions of the launcher bundle found in " + pluginsDir);
        }
        return launchers[0];
    }

    public static File findConfigurationArea(File location) {
        return new File(location, "configuration");
    }

    public File getWorkingDirectory() {
        return this.equinoxDirectory;
    }

    public String getJvmExecutable() {
        return null;
    }

    public File getLauncherJar() {
        if (this.launcherJar == null) {
            this.launcherJar = EquinoxInstallationLaunchConfiguration.findLauncherJar(this.equinoxDirectory);
        }
        return this.launcherJar;
    }

    public String[] getVMArguments() {
        return new String[0];
    }

    public String[] getProgramArguments() {
        return this.programArguments;
    }

    public Map<String, String> getEnvironment() {
        return Collections.emptyMap();
    }
}

