/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.SourcepathEntry;
import org.eclipse.tycho.compiler.AbstractOsgiCompilerMojo;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.model.classpath.SourceFolderClasspathEntry;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class OsgiTestCompilerMojo
extends AbstractOsgiCompilerMojo {
    @Override
    public List<SourcepathEntry> getSourcepath() throws MojoExecutionException {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        File testOutputDirectory = reactorProject.getBuildDirectory().getTestOutputDirectory();
        Stream<File> mavenDirectories = this.project.getTestCompileSourceRoots().stream().map(dir -> new File((String)dir)).filter(File::isDirectory);
        Stream<File> sourceFolders = this.getSourceFolders();
        return Stream.concat(mavenDirectories, sourceFolders).distinct().map(file -> new ClasspathSourcepathEntry((File)file, testOutputDirectory)).collect(Collectors.toList());
    }

    private Stream<File> getSourceFolders() throws MojoExecutionException {
        return this.getEclipsePluginProject().getClasspathEntries().stream().filter(SourceFolderClasspathEntry.class::isInstance).map(SourceFolderClasspathEntry.class::cast).filter(e -> Boolean.parseBoolean((String)e.getAttributes().get("test"))).map(SourceFolderClasspathEntry::getSourcePath);
    }

    @Override
    protected String getDependencyScope() {
        return "test";
    }

    private final class ClasspathSourcepathEntry
    implements SourcepathEntry {
        private final File sourceDirectory;
        private File outputDirectory;

        private ClasspathSourcepathEntry(File sourceDirectory, File outputDirectory) {
            this.sourceDirectory = sourceDirectory;
            this.outputDirectory = outputDirectory;
        }

        public File getSourcesRoot() {
            return this.sourceDirectory;
        }

        public File getOutputDirectory() {
            return this.outputDirectory;
        }

        public List<String> getIncludes() {
            return null;
        }

        public List<String> getExcludes() {
            return null;
        }
    }
}

