/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler;

import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;

@Mojo(name="validate-classpath", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ValidateClassPathMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        if (projectType instanceof OsgiBundleProject) {
            OsgiBundleProject bundleProject = (OsgiBundleProject)projectType;
            ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
            if (reactorProject.getContextValue(TychoConstants.CTX_DEPENDENCY_ARTIFACTS) != null) {
                bundleProject.getClasspath(reactorProject);
            } else {
                this.getLog().info((CharSequence)"Skipped classpath validation as project is currently not resolved");
            }
        }
    }
}

