/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.ds;

import aQute.bnd.component.DSAnnotations;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.DeclarativeServicesConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.ds.DeclarativeServiceConfigurationReader;
import org.eclipse.tycho.ds.HeaderConfiguration;
import org.eclipse.tycho.helper.PluginRealmHelper;
import org.osgi.framework.Version;

@Mojo(name="declarative-services", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class DeclarativeServicesMojo
extends AbstractMojo {
    public static final String CONTEXT_KEY_MANIFEST_HEADER = "DeclarativeServicesMojoHeader";
    public static final String SERVICE_COMPONENT_HEADER = "Service-Component";
    @Parameter(property="tycho.ds.classpath", defaultValue="true")
    private boolean classpath = Boolean.parseBoolean("true");
    @Parameter(property="tycho.ds.version", defaultValue="1.3")
    private String dsVersion = "1.3";
    @Parameter(property="tycho.ds.enabled", defaultValue="false")
    private boolean enabled = false;
    @Parameter(property="tycho.ds.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="tycho.ds.path", defaultValue="OSGI-INF")
    private String path = "OSGI-INF";
    @Parameter(property="tycho.ds.header", defaultValue="auto")
    private HeaderConfiguration header = HeaderConfiguration.auto;
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Component
    private TychoProjectManager manager;
    @Component
    private DeclarativeServiceConfigurationReader configurationReader;
    @Component
    private PluginRealmHelper pluginRealmHelper;
    @Parameter(property="session", readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        TychoProject projectType = this.manager.getTychoProject(this.project).orElse(null);
        if (projectType instanceof OsgiBundleProject) {
            OsgiBundleProject bundleProject = (OsgiBundleProject)projectType;
            try {
                DeclarativeServicesConfiguration configuration = this.configurationReader.getConfiguration(this.project);
                File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
                if (configuration == null || !outputDirectory.exists()) {
                    return;
                }
                Version dsVersion = configuration.getSpecificationVersion();
                Log log = this.getLog();
                log.info((CharSequence)("Using Declarative Service specification version " + dsVersion + " to generate component definitions"));
                boolean isDs12 = dsVersion.getMajor() == 1 && dsVersion.getMinor() == 2;
                String childPath = configuration.getPath();
                File targetDirectory = new File(outputDirectory, childPath);
                File projectBaseDir = new File(this.project.getBasedir(), childPath);
                try (Jar mavenProjectJar = new Jar(this.project.getName(), outputDirectory, null);
                     Analyzer analyzer = new Analyzer(mavenProjectJar);){
                    Map directory = analyzer.getJar().getDirectory("OSGI-INF");
                    if (directory != null) {
                        directory.clear();
                    }
                    ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
                    List classpath = bundleProject.getClasspath(reactorProject);
                    for (ClasspathEntry entry : classpath) {
                        List locations = entry.getLocations();
                        for (File file : locations) {
                            if (!file.exists() || file.equals(outputDirectory) || file.length() <= 0L) continue;
                            try {
                                analyzer.addClasspath(file);
                            }
                            catch (IOException e) {
                                log.warn((CharSequence)("Can't add file " + file + " as classpath entry to ds analyzer"), (Throwable)(log.isDebugEnabled() ? e : null));
                            }
                        }
                    }
                    this.pluginRealmHelper.visitPluginExtensions(this.project, this.session, ClasspathContributor.class, cpc -> {
                        List list = cpc.getAdditionalClasspathEntries(this.project, "compile");
                        if (list != null && !list.isEmpty()) {
                            for (ClasspathEntry entry : list) {
                                for (File file : entry.getLocations()) {
                                    try {
                                        analyzer.addClasspath(file);
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                    });
                    if (isDs12) {
                        log.warn((CharSequence)"Generating of XML DS 1.2 might be not fully supported and validation is disabled (see https://github.com/bndtools/bnd/issues/5548), please upgrade to at least 1.3");
                    } else {
                        analyzer.setProperty("-dsannotations-options", "version;maximum=" + dsVersion.toString());
                    }
                    analyzer.addBasicPlugin((Object)new DSAnnotations());
                    analyzer.analyze();
                    for (String warning : analyzer.getWarnings()) {
                        log.warn((CharSequence)warning);
                    }
                    for (String error : analyzer.getErrors()) {
                        log.error((CharSequence)error);
                    }
                    if (!analyzer.getErrors().isEmpty()) {
                        throw new MojoFailureException("Generation of Declarative Service components failed, see log for details");
                    }
                    String components = analyzer.getProperty(SERVICE_COMPONENT_HEADER);
                    if (components == null || components.isBlank()) {
                        return;
                    }
                    if (this.header == HeaderConfiguration.replace || this.header == HeaderConfiguration.auto && bundleProject.getManifestValue(SERVICE_COMPONENT_HEADER, this.project) == null) {
                        reactorProject.setContextValue(CONTEXT_KEY_MANIFEST_HEADER, (Object)components);
                    }
                    int generated = 0;
                    int keep = 0;
                    for (String component : components.split(",\\s*")) {
                        String name = FilenameUtils.getName((String)component);
                        if (new File(projectBaseDir, name).isFile()) {
                            ++keep;
                            continue;
                        }
                        log.info((CharSequence)("\t" + name));
                        ++generated;
                        Resource resource = analyzer.getJar().getResource(component);
                        if (resource == null) continue;
                        File file = new File(targetDirectory, name);
                        file.getParentFile().mkdirs();
                        resource.write(file);
                    }
                    if (keep > 0) {
                        log.info((CharSequence)(generated + " component(s) where generated, " + keep + " where kept."));
                    } else {
                        log.info((CharSequence)(generated + " component(s) where generated."));
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof MojoFailureException) {
                    MojoFailureException mfe = (MojoFailureException)e;
                    throw mfe;
                }
                throw new MojoFailureException("Generation of DS components failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

