/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.maven.MavenDependencyInjector;
import org.eclipse.tycho.core.maven.utils.PluginRealmHelper;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;
import org.eclipse.tycho.core.osgitools.targetplatform.MultiEnvironmentDependencyArtifacts;
import org.eclipse.tycho.core.p2.P2ArtifactRepositoryLayout;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.osgi.adapters.MavenLoggerAdapter;
import org.eclipse.tycho.p2.facade.internal.AttachedArtifact;
import org.eclipse.tycho.p2.metadata.DependencyMetadataGenerator;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IDependencyMetadata;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.resolver.P2MetadataProvider;
import org.eclipse.tycho.p2.resolver.PomDependencyProcessor;
import org.eclipse.tycho.p2.resolver.TargetDefinitionFile;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManagerFacade;

@Component(role=DependencyResolver.class, hint="p2", instantiationStrategy="per-lookup")
public class P2DependencyResolver
extends AbstractLogEnabled
implements DependencyResolver,
Initializable {
    public static final String ROLE_HINT = "p2";
    @Requirement
    private EquinoxServiceFactory equinox;
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private PluginRealmHelper pluginRealmHelper;
    private P2ResolverFactory resolverFactory;
    private DependencyMetadataGenerator generator;
    private ReactorRepositoryManagerFacade reactorRepositoryManager;

    public void setupProjects(MavenSession session, MavenProject project, ReactorProject reactorProject) {
        TargetPlatformConfiguration configuration = (TargetPlatformConfiguration)project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION);
        List environments = configuration.getEnvironments();
        Map<String, IDependencyMetadata> metadata = this.getDependencyMetadata(session, project, environments, OptionalResolutionAction.OPTIONAL);
        LinkedHashSet primaryMetadata = new LinkedHashSet();
        LinkedHashSet secondaryMetadata = new LinkedHashSet();
        for (Map.Entry<String, IDependencyMetadata> entry : metadata.entrySet()) {
            primaryMetadata.addAll(entry.getValue().getMetadata(true));
            secondaryMetadata.addAll(entry.getValue().getMetadata(false));
        }
        reactorProject.setDependencyMetadata(true, primaryMetadata);
        reactorProject.setDependencyMetadata(false, secondaryMetadata);
    }

    protected Map<String, IDependencyMetadata> getDependencyMetadata(final MavenSession session, final MavenProject project, List<TargetEnvironment> environments, final OptionalResolutionAction optionalAction) {
        final LinkedHashMap<String, IDependencyMetadata> metadata = new LinkedHashMap<String, IDependencyMetadata>();
        metadata.put(null, this.generator.generateMetadata((IArtifactFacade)new AttachedArtifact(project, project.getBasedir(), null), environments, optionalAction));
        try {
            this.pluginRealmHelper.execute(session, project, new Runnable(){

                @Override
                public void run() {
                    try {
                        for (P2MetadataProvider provider : P2DependencyResolver.this.plexus.lookupList(P2MetadataProvider.class)) {
                            Map<String, IDependencyMetadata> providedMetadata = provider.getDependencyMetadata(session, project, null, optionalAction);
                            if (providedMetadata == null) continue;
                            metadata.putAll(providedMetadata);
                        }
                    }
                    catch (ComponentLookupException componentLookupException) {
                        // empty catch block
                    }
                }
            }, new PluginRealmHelper.PluginFilter(){

                public boolean accept(PluginDescriptor descriptor) {
                    return P2DependencyResolver.this.isTychoP2Plugin(descriptor);
                }
            });
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException(e);
        }
        return metadata;
    }

    protected boolean isTychoP2Plugin(PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor.getArtifactMap().containsKey("org.eclipse.tycho:tycho-p2-facade")) {
            return true;
        }
        for (ComponentDependency dependency : pluginDescriptor.getDependencies()) {
            if (!"org.eclipse.tycho".equals(dependency.getGroupId()) || !"tycho-p2-facade".equals(dependency.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public TargetPlatform computePreliminaryTargetPlatform(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects) {
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)project);
        ExecutionEnvironmentConfiguration ee = TychoProjectUtils.getExecutionEnvironmentConfiguration((MavenProject)project);
        TargetPlatformConfigurationStub tpConfiguration = new TargetPlatformConfigurationStub();
        tpConfiguration.setIncludePackedArtifacts(configuration.isIncludePackedArtifacts());
        PomDependencyCollector pomDependencies = null;
        if ("consider".equals(configuration.getPomDependencies())) {
            pomDependencies = this.collectPomDependencies(project, reactorProjects, session);
        } else {
            pomDependencies = this.resolverFactory.newPomDependencyCollector();
            pomDependencies.setProjectLocation(project.getBasedir());
        }
        for (ArtifactRepository repository : project.getRemoteArtifactRepositories()) {
            this.addEntireP2RepositoryToTargetPlatform(repository, tpConfiguration);
        }
        tpConfiguration.setEnvironments(configuration.getEnvironments());
        for (File file : configuration.getTargets()) {
            this.addTargetFileContentToTargetPlatform(file, configuration.getTargetDefinitionIncludeSourceMode(), tpConfiguration);
        }
        tpConfiguration.addFilters(configuration.getFilters());
        return this.reactorRepositoryManager.computePreliminaryTargetPlatform(DefaultReactorProject.adapt((MavenProject)project), tpConfiguration, ee, reactorProjects, pomDependencies);
    }

    private ReactorProject getThisReactorProject(MavenSession session, MavenProject project, TargetPlatformConfiguration configuration) {
        List environments = configuration.getEnvironments();
        OptionalResolutionAction optionalAction = configuration.getDependencyResolverConfiguration().getOptionalResolutionAction();
        Map<String, IDependencyMetadata> dependencyMetadata = this.getDependencyMetadata(session, project, environments, optionalAction);
        final LinkedHashSet metadata = new LinkedHashSet();
        final LinkedHashSet secondaryMetadata = new LinkedHashSet();
        for (Map.Entry<String, IDependencyMetadata> entry : dependencyMetadata.entrySet()) {
            metadata.addAll(entry.getValue().getMetadata(true));
            secondaryMetadata.addAll(entry.getValue().getMetadata(false));
        }
        DefaultReactorProject reactorProjet = new DefaultReactorProject(project){

            public Set<?> getDependencyMetadata(boolean primary) {
                return primary ? metadata : secondaryMetadata;
            }
        };
        return reactorProjet;
    }

    private PomDependencyCollector collectPomDependencies(MavenProject project, List<ReactorProject> reactorProjects, MavenSession session) {
        Collection artifacts;
        HashSet<String> projectIds = new HashSet<String>();
        for (ReactorProject p : reactorProjects) {
            String key = ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion());
            projectIds.add(key);
        }
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("compile");
        try {
            artifacts = this.projectDependenciesResolver.resolve(project, scopes, session);
        }
        catch (MultipleArtifactsNotFoundException e) {
            HashSet missing = new HashSet(e.getMissingArtifacts());
            Iterator it = missing.iterator();
            while (it.hasNext()) {
                Artifact a = (Artifact)it.next();
                String key = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getBaseVersion());
                if (!projectIds.contains(key)) continue;
                it.remove();
            }
            if (!missing.isEmpty()) {
                throw new RuntimeException("Could not resolve project dependencies", e);
            }
            artifacts = e.getResolvedArtifacts();
            artifacts.removeAll(e.getMissingArtifacts());
        }
        catch (AbstractArtifactResolutionException e) {
            throw new RuntimeException("Could not resolve project dependencies", e);
        }
        ArrayList<Artifact> externalArtifacts = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            String key = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion());
            if (projectIds.contains(key)) continue;
            externalArtifacts.add(artifact);
        }
        PomDependencyProcessor pomDependencyProcessor = new PomDependencyProcessor(session, this.repositorySystem, this.resolverFactory, (LocalRepositoryP2Indices)this.equinox.getService(LocalRepositoryP2Indices.class), this.getLogger());
        return pomDependencyProcessor.collectPomDependencies(project, externalArtifacts);
    }

    private void addEntireP2RepositoryToTargetPlatform(ArtifactRepository repository, TargetPlatformConfigurationStub resolutionContext) {
        try {
            if (repository.getLayout() instanceof P2ArtifactRepositoryLayout) {
                URI url = new URL(repository.getUrl()).toURI();
                resolutionContext.addP2Repository(new MavenRepositoryLocation(repository.getId(), url));
                this.getLogger().debug("Added p2 repository " + repository.getId() + " (" + repository.getUrl() + ")");
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid repository URL: " + repository.getUrl(), e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid repository URL: " + repository.getUrl(), e);
        }
    }

    private void addTargetFileContentToTargetPlatform(File targetFile, IncludeSourceMode includeSourcesMode, TargetPlatformConfigurationStub resolutionContext) {
        TargetDefinitionFile target = TargetDefinitionFile.read(targetFile, includeSourcesMode);
        resolutionContext.addTargetDefinition((TargetDefinition)target);
    }

    public DependencyArtifacts resolveDependencies(MavenSession session, MavenProject project, TargetPlatform targetPlatform, List<ReactorProject> reactorProjects, DependencyResolverConfiguration resolverConfiguration) {
        if (targetPlatform == null) {
            targetPlatform = TychoProjectUtils.getTargetPlatform((MavenProject)project);
        }
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)project);
        P2Resolver osgiResolverImpl = this.resolverFactory.createResolver((MavenLogger)new MavenLoggerAdapter(this.getLogger(), DebugUtils.isDebugEnabled((MavenSession)session, (MavenProject)project)));
        return this.doResolveDependencies(session, project, reactorProjects, resolverConfiguration, targetPlatform, osgiResolverImpl, configuration);
    }

    private DependencyArtifacts doResolveDependencies(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects, DependencyResolverConfiguration resolverConfiguration, TargetPlatform targetPlatform, P2Resolver resolver, TargetPlatformConfiguration configuration) {
        HashMap<File, ReactorProject> projects = new HashMap<File, ReactorProject>();
        resolver.setEnvironments(configuration.getEnvironments());
        resolver.setAdditionalFilterProperties(configuration.getProfileProperties());
        for (ReactorProject otherProject : reactorProjects) {
            projects.put(otherProject.getBasedir(), otherProject);
        }
        if (resolverConfiguration != null) {
            for (Dependency dependency : resolverConfiguration.getExtraRequirements()) {
                resolver.addDependency(dependency.getType(), dependency.getArtifactId(), dependency.getVersion());
            }
        }
        ReactorProject optionalDependencyPreparedProject = this.getThisReactorProject(session, project, configuration);
        if (!this.isAllowConflictingDependencies(project, configuration)) {
            List results = resolver.resolveDependencies(targetPlatform, optionalDependencyPreparedProject);
            MultiEnvironmentDependencyArtifacts multiPlatform = new MultiEnvironmentDependencyArtifacts(DefaultReactorProject.adapt((MavenProject)project));
            for (int i = 0; i < configuration.getEnvironments().size(); ++i) {
                TargetEnvironment environment = (TargetEnvironment)configuration.getEnvironments().get(i);
                P2ResolutionResult result = (P2ResolutionResult)results.get(i);
                DefaultDependencyArtifacts platform = this.newDefaultTargetPlatform(DefaultReactorProject.adapt((MavenProject)project), projects, result);
                multiPlatform.addPlatform(environment, platform);
            }
            return multiPlatform;
        }
        P2ResolutionResult result = resolver.collectProjectDependencies(targetPlatform, optionalDependencyPreparedProject);
        return this.newDefaultTargetPlatform(DefaultReactorProject.adapt((MavenProject)project), projects, result);
    }

    private boolean isAllowConflictingDependencies(MavenProject project, TargetPlatformConfiguration configuration) {
        Boolean allow;
        String packaging = project.getPackaging();
        if (("eclipse-update-site".equals(packaging) || "eclipse-feature".equals(packaging)) && (allow = configuration.getAllowConflictingDependencies()) != null) {
            return allow;
        }
        return false;
    }

    protected DefaultDependencyArtifacts newDefaultTargetPlatform(ReactorProject project, Map<File, ReactorProject> projects, P2ResolutionResult result) {
        DefaultDependencyArtifacts platform = new DefaultDependencyArtifacts(project);
        platform.addNonReactorUnits(result.getNonReactorUnits());
        for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
            DefaultArtifactKey key = new DefaultArtifactKey(entry.getType(), entry.getId(), entry.getVersion());
            ReactorProject otherProject = projects.get(entry.getLocation());
            if (otherProject != null) {
                platform.addReactorArtifact((ArtifactKey)key, otherProject, entry.getClassifier(), entry.getInstallableUnits());
                continue;
            }
            platform.addArtifactFile((ArtifactKey)key, entry.getLocation(), entry.getInstallableUnits());
        }
        return platform;
    }

    public void initialize() throws InitializationException {
        this.resolverFactory = (P2ResolverFactory)this.equinox.getService(P2ResolverFactory.class);
        this.generator = (DependencyMetadataGenerator)this.equinox.getService(DependencyMetadataGenerator.class, "(role-hint=dependency-only)");
        this.reactorRepositoryManager = (ReactorRepositoryManagerFacade)this.equinox.getService(ReactorRepositoryManagerFacade.class);
    }

    public void injectDependenciesIntoMavenModel(MavenProject project, AbstractTychoProject projectType, DependencyArtifacts dependencyArtifacts, Logger logger) {
        MavenDependencyInjector.injectMavenDependencies((MavenProject)project, (DependencyArtifacts)dependencyArtifacts, (BundleReader)this.bundleReader, (Logger)logger);
    }
}

