/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TargetPlatformService;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.eclipse.tycho.packaging.FeatureXmlTransformer;
import org.eclipse.tycho.packaging.LicenseFeatureHelper;
import org.eclipse.tycho.packaging.UpdateSiteAssembler;

@Mojo(name="package-feature", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class PackageFeatureMojo
extends AbstractTychoPackagingMojo {
    private static final Object LOCK = new Object();
    private static final String FEATURE_PROPERTIES = "feature.properties";
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(property="project.build.directory")
    private File outputDirectory;
    @Parameter(property="project.basedir")
    private File basedir;
    @Parameter(defaultValue="${project.basedir}/feature.xml")
    private File featureFile;
    @Parameter(property="project.build.finalName", alias="jarName", required=true)
    private String finalName;
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean deployableFeature = false;
    @Parameter(defaultValue="${project.build.directory}/site")
    private File target;
    @Component
    private FeatureXmlTransformer featureXmlTransformer;
    @Component
    private LicenseFeatureHelper licenseFeatureHelper;
    @Component
    private TargetPlatformService platformService;
    @Component
    private BuildPropertiesParser buildPropertiesParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object object = LOCK;
        synchronized (object) {
            Feature feature;
            this.outputDirectory.mkdirs();
            if (!this.featureFile.isFile()) {
                throw new MojoExecutionException("The featureFile parameter must represent a valid file");
            }
            try {
                feature = Feature.read((File)this.featureFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading " + this.featureFile, (Exception)e);
            }
            File licenseFeature = this.licenseFeatureHelper.getLicenseFeature(feature, this.project);
            this.updateLicenseProperties(feature, licenseFeature);
            File featureXml = new File(this.outputDirectory, "feature.xml");
            try {
                this.expandVersionQualifiers(feature);
                Feature.write((Feature)feature, (File)featureXml);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error updating feature.xml", (Exception)e);
            }
            BuildProperties buildProperties = this.buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)this.project));
            this.checkBinIncludesExist(buildProperties, new String[0]);
            File featureProperties = this.getFeatureProperties(licenseFeature, buildProperties);
            File outputJar = new File(this.outputDirectory, this.finalName + ".jar");
            outputJar.getParentFile().mkdirs();
            MavenArchiver archiver = new MavenArchiver();
            JarArchiver jarArchiver = this.getJarArchiver();
            archiver.setArchiver(jarArchiver);
            archiver.setOutputFile(outputJar);
            jarArchiver.setDestFile(outputJar);
            try {
                if (this.additionalFileSets != null) {
                    for (DefaultFileSet fileSet : this.additionalFileSets) {
                        File directory = fileSet.getDirectory();
                        if (directory == null || !directory.isDirectory()) continue;
                        archiver.getArchiver().addFileSet((FileSet)fileSet);
                    }
                }
                archiver.getArchiver().addFileSet(this.getManuallyIncludedFiles(buildProperties));
                if (licenseFeature != null) {
                    archiver.getArchiver().addArchivedFileSet(this.licenseFeatureHelper.getLicenseFeatureFileSet(licenseFeature));
                }
                archiver.getArchiver().addFile(featureXml, "feature.xml");
                if (featureProperties != null) {
                    archiver.getArchiver().addFile(featureProperties, FEATURE_PROPERTIES);
                }
                if (this.archive == null) {
                    this.archive = new MavenArchiveConfiguration();
                    this.archive.setAddMavenDescriptor(false);
                }
                MavenProject mavenProject = this.project;
                archiver.createArchive(this.session, mavenProject, this.archive);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error creating feature package", e);
            }
            this.project.getArtifact().setFile(outputJar);
            if (this.deployableFeature) {
                this.assembleDeployableFeature();
            }
        }
    }

    private void updateLicenseProperties(Feature feature, File licenseFeatureFile) {
        feature.setLicenseFeature(null);
        feature.setLicenseFeatureVersion(null);
        if (licenseFeatureFile != null) {
            Feature licenseFeature = Feature.loadFeature((File)licenseFeatureFile);
            if (licenseFeature.getLicenseURL() != null) {
                feature.setLicenseURL(licenseFeature.getLicenseURL());
            }
            if (licenseFeature.getLicense() != null) {
                feature.setLicense(licenseFeature.getLicense());
            }
        }
    }

    private File getFeatureProperties(File licenseFeature, BuildProperties buildProperties) throws MojoExecutionException {
        try {
            File localFeatureProperties = new File(this.basedir, FEATURE_PROPERTIES);
            File targetFeatureProperties = new File(this.outputDirectory, FEATURE_PROPERTIES);
            if (targetFeatureProperties.exists() && !targetFeatureProperties.delete()) {
                throw new MojoExecutionException("Could not delete file " + targetFeatureProperties.getAbsolutePath());
            }
            if (buildProperties.getBinIncludes().contains(FEATURE_PROPERTIES) && localFeatureProperties.canRead()) {
                Files.copy(localFeatureProperties.toPath(), targetFeatureProperties.toPath(), new CopyOption[0]);
            }
            if (licenseFeature != null) {
                this.appendToOrAddFeatureProperties(targetFeatureProperties, licenseFeature);
            }
            if (targetFeatureProperties.exists()) {
                return targetFeatureProperties;
            }
            return null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create feature.properties file for project " + this.project, (Exception)e);
        }
    }

    private void appendToOrAddFeatureProperties(File targetFeatureProperties, File licenseFeature) throws IOException {
        block17: {
            try (ZipFile zip = new ZipFile(licenseFeature);){
                ZipEntry entry = zip.getEntry(FEATURE_PROPERTIES);
                if (entry == null) break block17;
                try (InputStream inputStream = zip.getInputStream(entry);
                     FileWriter writer = new FileWriter(targetFeatureProperties.getAbsolutePath(), true);){
                    if (targetFeatureProperties.exists()) {
                        IOUtil.copy((String)"\n", (Writer)writer);
                    }
                    IOUtil.copy((InputStream)inputStream, (Writer)writer);
                }
            }
        }
    }

    private FileSet getManuallyIncludedFiles(BuildProperties buildProperties) {
        ArrayList<String> binExcludes = new ArrayList<String>(buildProperties.getBinExcludes());
        binExcludes.add("feature.xml");
        binExcludes.add(FEATURE_PROPERTIES);
        return this.getFileSet(this.basedir, buildProperties.getBinIncludes(), binExcludes);
    }

    private void assembleDeployableFeature() throws MojoExecutionException {
        UpdateSiteAssembler assembler = new UpdateSiteAssembler(this.plexus, this.target);
        this.getTychoProjectFacet().getDependencyWalker(DefaultReactorProject.adapt((MavenProject)this.project)).walk((ArtifactDependencyVisitor)assembler);
    }

    private void expandVersionQualifiers(Feature feature) throws MojoFailureException {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        feature.setVersion(reactorProject.getExpandedVersion());
        TargetPlatform targetPlatform = this.platformService.getTargetPlatform(reactorProject).orElse(null);
        if (targetPlatform == null) {
            this.getLog().warn((CharSequence)"Skipping version reference expansion in eclipse-feature project using the deprecated -Dtycho.targetPlatform configuration");
            return;
        }
        this.featureXmlTransformer.expandReferences(feature, targetPlatform);
    }

    private JarArchiver getJarArchiver() throws MojoExecutionException {
        try {
            return (JarArchiver)this.plexus.lookup(JarArchiver.class, "jar");
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to get JarArchiver", (Exception)((Object)e));
        }
    }
}

