/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.engine;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.versions.bundle.MutableBundleManifest;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.engine.VersionsEngine;
import org.eclipse.tycho.versions.pom.MutablePomFile;

@Component(role=PomVersionUpdater.class, instantiationStrategy="per-lookup")
public class PomVersionUpdater {
    @Requirement
    private Logger logger;
    @Requirement
    private VersionsEngine engine;
    private static final Map<String, VersionAdaptor> updaters = new HashMap<String, VersionAdaptor>();
    private Collection<ProjectMetadata> projects;

    public void setProjects(Collection<ProjectMetadata> projects) {
        this.projects = projects;
        this.engine.setProjects(projects);
    }

    public void apply() throws IOException {
        for (ProjectMetadata project : this.projects) {
            String osgiVersion;
            MutablePomFile pom = project.getMetadata(MutablePomFile.class);
            if (pom == null) {
                this.logger.info("Not a maven project " + project.getBasedir());
                continue;
            }
            String pomVersion = Versions.toCanonicalVersion(pom.getVersion());
            VersionAdaptor adaptor = updaters.get(pom.getPackaging());
            if (adaptor == null || Versions.isVersionEquals(pomVersion, osgiVersion = Versions.toCanonicalVersion(adaptor.getVersion(project)))) continue;
            this.engine.addVersionChange(new VersionChange(pom, osgiVersion));
        }
        this.engine.apply();
    }

    static {
        VersionAdaptor bundleVersionAdaptor = new VersionAdaptor(){

            @Override
            public String getVersion(ProjectMetadata project) throws IOException {
                MutableBundleManifest manifest = MutableBundleManifest.read(new File(project.getBasedir(), "META-INF/MANIFEST.MF"));
                return manifest.getVersion();
            }
        };
        updaters.put("eclipse-plugin", bundleVersionAdaptor);
        updaters.put("eclipse-test-plugin", bundleVersionAdaptor);
        updaters.put("eclipse-feature", new VersionAdaptor(){

            @Override
            public String getVersion(ProjectMetadata project) throws IOException {
                Feature feature = Feature.read((File)new File(project.getBasedir(), "feature.xml"));
                return feature.getVersion();
            }
        });
        updaters.put("eclipse-application", new VersionAdaptor(){

            @Override
            public String getVersion(ProjectMetadata project) throws IOException {
                MutablePomFile pom = project.getMetadata(MutablePomFile.class);
                ProductConfiguration product = ProductConfiguration.read((File)new File(project.getBasedir(), pom.getArtifactId() + ".product"));
                return product.getVersion();
            }
        });
    }

    private static interface VersionAdaptor {
        public String getVersion(ProjectMetadata var1) throws IOException;
    }
}

