/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;
import org.eclipse.tycho.versions.pom.MutablePomFile;

public abstract class ProductFileManipulator
extends AbstractMetadataManipulator {
    protected void applyChangeToProduct(ProjectMetadata project, ProductConfiguration product, String productFileName, VersionChange change) {
        block6: {
            block5: {
                if (!this.isSameProject(project, change.getProject())) break block5;
                if (!change.getVersion().equals(product.getVersion())) break block6;
                this.logger.info("  " + productFileName + "//product/@version: " + change.getVersion() + " => " + change.getNewVersion());
                product.setVersion(change.getNewVersion());
                break block6;
            }
            if (this.isBundle(change.getProject())) {
                for (PluginRef plugin : product.getPlugins()) {
                    if (!change.getArtifactId().equals(plugin.getId()) || !change.getVersion().equals(plugin.getVersion())) continue;
                    this.logger.info("  " + productFileName + "//product/plugins/plugin/@id=" + plugin.getId() + "/@version: " + change.getVersion() + " => " + change.getNewVersion());
                    plugin.setVersion(change.getNewVersion());
                }
            } else if (this.isFeature(change.getProject().getPackaging())) {
                for (FeatureRef feature : product.getFeatures()) {
                    if (!change.getArtifactId().equals(feature.getId()) || !change.getVersion().equals(feature.getVersion())) continue;
                    this.logger.info("  " + productFileName + "//product/features/feature/@id=" + feature.getId() + "/@version: " + change.getVersion() + " => " + change.getNewVersion());
                    feature.setVersion(change.getNewVersion());
                }
            }
        }
    }

    protected boolean isSameProject(ProjectMetadata project1, MutablePomFile project2) {
        MutablePomFile project1Pom = project1.getMetadata(MutablePomFile.class);
        return project1Pom.getArtifactId().equals(project2.getArtifactId()) && project1Pom.getGroupId().equals(project2.getGroupId());
    }
}

