/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Type;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.AbstractItem;
import org.eclipse.yasson.internal.unmarshaller.CurrentItem;
import org.eclipse.yasson.model.ClassModel;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.JsonContext;

public abstract class AbstractContainerSerializer<T>
extends AbstractItem<T>
implements JsonbSerializer<T> {
    protected AbstractContainerSerializer(SerializerBuilder builder) {
        super(builder);
    }

    public AbstractContainerSerializer(CurrentItem<?> wrapper, Type runtimeType, ClassModel classModel, JsonBindingModel wrapperModel) {
        super(wrapper, runtimeType, classModel, wrapperModel);
    }

    public final void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        if (this.getWrapperModel().getContext() == JsonContext.JSON_OBJECT) {
            this.writeStart(this.getWrapperModel().getWriteName(), generator);
        } else {
            this.writeStart(generator);
        }
        this.serializeInternal(obj, generator, ctx);
        this.writeEnd(generator);
    }

    protected abstract void serializeInternal(T var1, JsonGenerator var2, SerializationContext var3);

    protected abstract void writeStart(JsonGenerator var1);

    protected void writeEnd(JsonGenerator generator) {
        generator.writeEnd();
    }

    protected abstract void writeStart(String var1, JsonGenerator var2);

    protected <X> void serializerCaptor(JsonbSerializer<?> serializer, X object, JsonGenerator generator, SerializationContext ctx) {
        serializer.serialize(object, generator, ctx);
    }
}

