/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Type;
import java.util.Objects;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.unmarshaller.CurrentItem;
import org.eclipse.yasson.model.ClassModel;
import org.eclipse.yasson.model.JsonBindingModel;

public class AbstractSerializerBuilder<T extends AbstractSerializerBuilder> {
    protected CurrentItem<?> wrapper;
    protected JsonBindingModel model;
    protected ClassModel classModel;
    protected Type runtimeType;
    protected Type genericType;
    protected final JsonbContext jsonbContext;

    public AbstractSerializerBuilder(JsonbContext jsonbContext) {
        Objects.requireNonNull(jsonbContext);
        this.jsonbContext = jsonbContext;
    }

    public T withWrapper(CurrentItem<?> wrapper) {
        this.wrapper = wrapper;
        return (T)this;
    }

    public T withModel(JsonBindingModel model) {
        this.model = model;
        return (T)this;
    }

    protected ClassModel getClassModel(Class<?> rawType) {
        ClassModel classModel = this.jsonbContext.getMappingContext().getClassModel(rawType);
        if (classModel == null) {
            classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(rawType);
        }
        return classModel;
    }

    public CurrentItem<?> getWrapper() {
        return this.wrapper;
    }

    public JsonBindingModel getModel() {
        return this.model;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public Type getRuntimeType() {
        return this.runtimeType;
    }

    public T withType(Type type) {
        this.genericType = type;
        return (T)this;
    }

    public JsonbContext getJsonbContext() {
        return this.jsonbContext;
    }
}

