/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.naming;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.bind.config.PropertyNamingStrategy;
import org.eclipse.yasson.internal.naming.CaseInsensitiveStrategy;
import org.eclipse.yasson.internal.naming.IdentityStrategy;
import org.eclipse.yasson.internal.naming.LowerCaseWithDashesStrategy;
import org.eclipse.yasson.internal.naming.LowerCaseWithUnderscoresStrategy;
import org.eclipse.yasson.internal.naming.UpperCamelCaseStrategy;
import org.eclipse.yasson.internal.naming.UpperCamelCaseWithSpacesStrategy;

public class DefaultNamingStrategies {
    private static final Map<String, PropertyNamingStrategy> strategies;

    public static PropertyNamingStrategy getStrategy(String strategyName) {
        return strategies.get(strategyName);
    }

    static {
        HashMap<String, Object> collector = new HashMap<String, Object>();
        collector.put("LOWER_CASE_WITH_UNDERSCORES", new LowerCaseWithUnderscoresStrategy());
        collector.put("LOWER_CASE_WITH_DASHES", new LowerCaseWithDashesStrategy());
        collector.put("UPPER_CAMEL_CASE", new UpperCamelCaseStrategy());
        collector.put("UPPER_CAMEL_CASE_WITH_SPACES", new UpperCamelCaseWithSpacesStrategy());
        collector.put("IDENTITY", new IdentityStrategy());
        collector.put("CASE_INSENSITIVE", new CaseInsensitiveStrategy());
        strategies = Collections.unmodifiableMap(collector);
    }
}

