/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.AbstractContainerSerializer;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.ContainerModel;
import org.eclipse.yasson.internal.unmarshaller.EmbeddedItem;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.JsonContext;

public abstract class AbstractArraySerializer<T>
extends AbstractContainerSerializer<T>
implements EmbeddedItem {
    protected final JsonBindingModel containerModel;
    protected final Type arrayValType = this.resolveArrayType();

    protected AbstractArraySerializer(SerializerBuilder builder) {
        super(builder);
        this.containerModel = new ContainerModel(this.arrayValType, this.resolveContainerModelCustomization(this.arrayValType, builder.getJsonbContext()), JsonContext.JSON_ARRAY);
    }

    private Type resolveArrayType() {
        if (this.getRuntimeType() == null || this.getRuntimeType() == Object.class) {
            return Object.class;
        }
        if (this.getRuntimeType() instanceof ParameterizedType) {
            return ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[0]);
        }
        if (this.getRuntimeType() instanceof GenericArrayType) {
            return ReflectionUtils.resolveRawType(this, ((GenericArrayType)this.getRuntimeType()).getGenericComponentType());
        }
        return ReflectionUtils.getRawType(this.getRuntimeType()).getComponentType();
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartArray();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartArray(key);
    }
}

