/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Optional;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;
import org.eclipse.yasson.model.JsonBindingModel;

public abstract class AbstractNumberDeserializer<T extends Number>
extends AbstractValueTypeDeserializer<T> {
    public AbstractNumberDeserializer(Class<T> clazz, JsonBindingModel model) {
        super(clazz, model);
    }

    protected final Optional<Number> deserializeFormatted(String jsonValue, boolean integerOnly, JsonbContext jsonbContext) {
        if (this.getModel() == null || this.getModel().getCustomization() == null || this.getModel().getCustomization().getDeserializeNumberFormatter() == null) {
            return Optional.empty();
        }
        JsonbNumberFormatter numberFormat = this.getModel().getCustomization().getDeserializeNumberFormatter();
        NumberFormat format = NumberFormat.getInstance(jsonbContext.getConfigProperties().getLocale(numberFormat.getLocale()));
        ((DecimalFormat)format).applyPattern(numberFormat.getFormat());
        format.setParseIntegerOnly(integerOnly);
        try {
            return Optional.of(format.parse(jsonValue));
        }
        catch (ParseException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.PARSING_NUMBER, jsonValue, numberFormat.getFormat()));
        }
    }
}

