/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.function.Consumer;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.customization.Customization;

public abstract class AbstractNumberSerializer<T extends Number>
extends AbstractValueTypeSerializer<T> {
    public AbstractNumberSerializer(JsonBindingModel model) {
        super(model);
    }

    @Override
    protected final void serialize(T obj, JsonGenerator generator, String key, Marshaller marshaller) {
        if (!this.serializeFormatted(obj, formatted -> generator.write(key, formatted), marshaller.getJsonbContext())) {
            this.serializeNonFormatted(obj, generator, key);
        }
    }

    protected abstract void serializeNonFormatted(T var1, JsonGenerator var2, String var3);

    @Override
    protected void serialize(T obj, JsonGenerator generator, Marshaller marshaller) {
        if (!this.serializeFormatted(obj, arg_0 -> ((JsonGenerator)generator).write(arg_0), marshaller.getJsonbContext())) {
            this.serializeNonFormatted(obj, generator);
        }
    }

    protected abstract void serializeNonFormatted(T var1, JsonGenerator var2);

    private boolean serializeFormatted(T obj, Consumer<String> formattedConsumer, JsonbContext jsonbContext) {
        Customization customization = this.model.getCustomization();
        if (customization != null && customization.getSerializeNumberFormatter() != null) {
            JsonbNumberFormatter numberFormat = customization.getSerializeNumberFormatter();
            NumberFormat format = NumberFormat.getInstance(jsonbContext.getConfigProperties().getLocale(numberFormat.getLocale()));
            ((DecimalFormat)format).applyPattern(numberFormat.getFormat());
            formattedConsumer.accept(format.format(obj));
            return true;
        }
        return false;
    }
}

