/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.math.BigInteger;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractNumberDeserializer;
import org.eclipse.yasson.model.JsonBindingModel;

public class BigIntegerTypeDeserializer
extends AbstractNumberDeserializer<BigInteger> {
    public BigIntegerTypeDeserializer(JsonBindingModel model) {
        super(BigInteger.class, model);
    }

    @Override
    public BigInteger deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        return this.deserializeFormatted(jsonValue, true, unmarshaller.getJsonbContext()).map(num -> new BigInteger(num.toString())).orElseGet(() -> {
            try {
                return new BigInteger(jsonValue);
            }
            catch (NumberFormatException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, BigInteger.class));
            }
        });
    }
}

