/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeSerializer;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.model.JsonBindingModel;

public class DateTypeSerializer
extends AbstractDateTimeSerializer<Date> {
    private DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(UTC);

    public DateTypeSerializer(JsonBindingModel model) {
        super(model);
    }

    @Override
    protected Instant toInstant(Date value) {
        return value.toInstant();
    }

    @Override
    protected String formatDefault(Date value, Locale locale) {
        return this.DEFAULT_FORMATTER.withLocale(locale).format(value.toInstant());
    }

    @Override
    protected String formatWithFormatter(Date value, DateTimeFormatter formatter) {
        return this.getZonedFormatter(formatter).format(this.toTemporalAccessor(value));
    }

    @Override
    protected String formatStrictIJson(Date value) {
        return JsonbDateFormatter.IJSON_DATE_FORMATTER.withZone(UTC).format(this.toTemporalAccessor(value));
    }

    @Override
    protected TemporalAccessor toTemporalAccessor(Date object) {
        return object.toInstant();
    }
}

