/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;
import org.eclipse.yasson.model.JsonBindingModel;

public class JsonNumberTypeDeserializer
extends AbstractValueTypeDeserializer<JsonNumber> {
    private static final String NUMBER = "number";

    public JsonNumberTypeDeserializer(JsonBindingModel model) {
        super(JsonNumber.class, model);
    }

    @Override
    protected JsonNumber deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        JsonBuilderFactory factory = unmarshaller.getJsonbContext().getJsonProvider().createBuilderFactory(null);
        try {
            Integer integer = Integer.parseInt(jsonValue);
            JsonObject jsonObject = factory.createObjectBuilder().add(NUMBER, integer.intValue()).build();
            return jsonObject.getJsonNumber(NUMBER);
        }
        catch (NumberFormatException integer) {
            try {
                Long l = Long.parseLong(jsonValue);
                JsonObject jsonObject = factory.createObjectBuilder().add(NUMBER, l.longValue()).build();
                return jsonObject.getJsonNumber(NUMBER);
            }
            catch (NumberFormatException numberFormatException) {
                JsonObject jsonObject = factory.createObjectBuilder().add(NUMBER, new BigDecimal(jsonValue)).build();
                return jsonObject.getJsonNumber(NUMBER);
            }
        }
    }
}

