/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.OptionalInt;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;
import org.eclipse.yasson.model.JsonBindingModel;

public class OptionalIntTypeDeserializer
extends AbstractValueTypeDeserializer<OptionalInt> {
    public OptionalIntTypeDeserializer(JsonBindingModel model) {
        super(OptionalInt.class, model);
    }

    @Override
    public OptionalInt deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonParser.Event next = ((JsonbParser)parser).moveToValue();
        if (next == JsonParser.Event.VALUE_NULL) {
            return OptionalInt.empty();
        }
        String value = parser.getString();
        return this.deserialize(value, (Unmarshaller)ctx, rtType);
    }

    @Override
    protected OptionalInt deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        try {
            return OptionalInt.of(Integer.parseInt(jsonValue));
        }
        catch (NumberFormatException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, OptionalInt.class));
        }
    }
}

