/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.unmarshaller.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.unmarshaller.DeserializerBuilder;
import org.eclipse.yasson.model.JsonBindingModel;

public abstract class AbstractJsonpDeserializer<T extends JsonValue>
extends AbstractContainerDeserializer<T> {
    protected AbstractJsonpDeserializer(DeserializerBuilder builder) {
        super(builder);
    }

    @Override
    protected void deserializeInternal(JsonbParser parser, Unmarshaller context) {
        this.parserContext = this.moveToFirst(parser);
        block10: while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            String lastKey = this.parserContext.getLastKeyName();
            switch (event) {
                case START_OBJECT: 
                case START_ARRAY: {
                    this.deserializeNext(parser, context);
                    continue block10;
                }
                case VALUE_STRING: {
                    this.appendString(lastKey, parser.getString());
                    continue block10;
                }
                case VALUE_NUMBER: {
                    this.appendNumber(lastKey, parser.getBigDecimal());
                    continue block10;
                }
                case VALUE_NULL: {
                    this.appendNull(lastKey);
                    continue block10;
                }
                case VALUE_FALSE: {
                    this.appendBoolean(lastKey, Boolean.FALSE);
                    continue block10;
                }
                case VALUE_TRUE: {
                    this.appendBoolean(lastKey, Boolean.TRUE);
                    continue block10;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    return;
                }
                case KEY_NAME: {
                    continue block10;
                }
            }
            throw new JsonbException(Messages.getMessage(MessageKeys.NOT_VALUE_TYPE, event));
        }
    }

    @Override
    protected JsonBindingModel getModel() {
        return this.getWrapperModel();
    }

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveToStartStructure();
        return parser.getCurrentLevel();
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        Class type = this.parserContext.getLastEvent() == JsonParser.Event.START_OBJECT ? JsonObject.class : JsonArray.class;
        JsonbDeserializer<?> deserializer = ((DeserializerBuilder)this.newUnmarshallerItemBuilder(context.getJsonbContext()).withType((Type)((Object)type))).build();
        this.appendResult(deserializer.deserialize(parser, (DeserializationContext)context, type));
    }

    protected abstract void appendString(String var1, String var2);

    protected abstract void appendNumber(String var1, BigDecimal var2);

    protected abstract void appendBoolean(String var1, Boolean var2);

    protected abstract void appendNull(String var1);
}

