/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.lang.reflect.Type;
import java.util.Base64;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;
import org.eclipse.yasson.model.JsonBindingModel;

public class ByteArrayBase64Deserializer
extends AbstractValueTypeDeserializer<byte[]> {
    public ByteArrayBase64Deserializer(JsonBindingModel model) {
        super(byte[].class, model);
    }

    @Override
    protected byte[] deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        return this.getDecoder(unmarshaller.getJsonbContext().getConfigProperties().getBinaryDataStrategy()).decode(jsonValue);
    }

    private Base64.Decoder getDecoder(String strategy) {
        switch (strategy) {
            case "BASE_64": {
                return Base64.getDecoder();
            }
            case "BASE_64_URL": {
                return Base64.getUrlDecoder();
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Invalid strategy: " + strategy));
    }
}

