/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.StringTypeDeserializer;
import org.eclipse.yasson.internal.unmarshaller.DeserializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.ObjectDeserializer;
import org.eclipse.yasson.model.PropertyModel;
import org.eclipse.yasson.model.TypeWrapper;

public class TypeWrapperDeserializer<T>
extends ObjectDeserializer<TypeWrapper<T>> {
    private Class<?> concreteWrappedClass;
    private String[] allowedClassNames;

    protected TypeWrapperDeserializer(DeserializerBuilder builder, String[] allowedClassNames) {
        super(builder);
        this.allowedClassNames = allowedClassNames;
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        String lastKeyName = this.parserContext.getLastKeyName();
        if (this.parserContext.getLastKeyName().equals("className")) {
            PropertyModel newPropertyModel = this.getClassModel().findPropertyModelByJsonReadName(lastKeyName);
            StringTypeDeserializer deserializer = new StringTypeDeserializer(newPropertyModel);
            String className = (String)deserializer.deserialize(parser, context, (Type)((Object)String.class));
            if (this.allowedClassNames.length > 0 && Stream.of(this.allowedClassNames).noneMatch(Predicate.isEqual(className))) {
                throw new JsonbException(Messages.getMessage(MessageKeys.CLASS_LOAD_NOT_ALLOWED, className));
            }
            try {
                this.concreteWrappedClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonbException("Cannot load class for ", (Throwable)e);
            }
        } else if (this.concreteWrappedClass != null && this.parserContext.getLastKeyName().equals("instance")) {
            this.deserializeInstance(parser, context);
        }
    }

    private void deserializeInstance(JsonParser parser, Unmarshaller context) {
        PropertyModel newPropertyModel = this.getClassModel().findPropertyModelByJsonReadName("instance");
        JsonbDeserializer<?> deserializer = ((DeserializerBuilder)((DeserializerBuilder)this.newUnmarshallerItemBuilder(context.getJsonbContext()).withType(this.concreteWrappedClass)).withModel(newPropertyModel)).build();
        this.appendResult(deserializer.deserialize(parser, (DeserializationContext)context, null));
    }
}

