/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.model.CreatorParam;

public class JsonbCreator {
    private final Executable executable;
    private final CreatorParam[] params;

    public JsonbCreator(Executable executable, CreatorParam[] creatorParams) {
        this.executable = executable;
        this.params = creatorParams;
    }

    public <T> T call(Object[] params, Class<T> on) {
        try {
            if (this.executable instanceof Constructor) {
                return ((Constructor)this.executable).newInstance(params);
            }
            return (T)((Method)this.executable).invoke(on, params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.ERROR_CALLING_JSONB_CREATOR, on), (Throwable)e);
        }
    }

    public boolean contains(String paramName) {
        return this.findByName(paramName) != null;
    }

    public CreatorParam findByName(String paramName) {
        for (CreatorParam param : this.params) {
            if (!param.getName().equals(paramName)) continue;
            return param;
        }
        return null;
    }

    public CreatorParam[] getParams() {
        return this.params;
    }
}

