/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.model;

import java.util.stream.Stream;
import javax.json.bind.adapter.JsonbAdapter;
import org.eclipse.yasson.model.TypeWrapper;

public class PolymorphismAdapter<T>
implements JsonbAdapter<T, TypeWrapper<T>> {
    private final String[] allowedClasses;

    public PolymorphismAdapter(Class ... allowedClasses) {
        this.allowedClasses = (String[])Stream.of(allowedClasses).map(Class::getName).toArray(value -> new String[allowedClasses.length]);
    }

    public String[] getAllowedClasses() {
        return this.allowedClasses;
    }

    public TypeWrapper<T> adaptToJson(T obj) throws Exception {
        TypeWrapper<T> wrapper = new TypeWrapper<T>();
        wrapper.setClassName(obj.getClass().getName());
        wrapper.setInstance(obj);
        return wrapper;
    }

    public T adaptFromJson(TypeWrapper<T> obj) throws Exception {
        return obj.getInstance();
    }
}

