/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Function;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.model.Property;
import org.eclipse.yasson.model.ReflectionPropagation;

public abstract class PropertyValuePropagation {
    private final Field field;
    private final Method getter;
    private final Method setter;
    protected boolean writable;
    protected boolean readable;

    protected PropertyValuePropagation(Property property, JsonbContext ctx) {
        this.field = property.getField();
        this.getter = property.getGetter();
        this.setter = property.getSetter();
        this.initReadable(this.field, this.getter, ctx);
        this.initWritable(this.field, this.setter, ctx);
    }

    public static PropertyValuePropagation createInstance(Property property, JsonbContext ctx) {
        return new ReflectionPropagation(property, ctx);
    }

    private void initReadable(Field field, Method getter, JsonbContext ctx) {
        boolean fieldReadable;
        boolean bl = fieldReadable = field == null || (field.getModifiers() & 0x88) == 0;
        if (!fieldReadable) {
            this.readable = false;
            return;
        }
        if (getter != null) {
            if (!this.isVisible(getter, ctx)) {
                return;
            }
            if (!Modifier.isPublic(getter.getModifiers()) || getter.getDeclaringClass().isAnonymousClass()) {
                getter.setAccessible(true);
            }
            this.acceptMethod(getter, OperationMode.GET);
            this.readable = true;
        } else if (this.isVisible(field, ctx)) {
            if (!Modifier.isPublic(field.getModifiers()) || field.getDeclaringClass().isAnonymousClass()) {
                field.setAccessible(true);
            }
            this.acceptField(field, OperationMode.GET);
            this.readable = true;
        }
    }

    private void initWritable(Field field, Method setter, JsonbContext ctx) {
        boolean fieldWritable;
        boolean bl = fieldWritable = field == null || (field.getModifiers() & 0x98) == 0;
        if (!fieldWritable) {
            this.writable = false;
            return;
        }
        if (setter != null) {
            if (!this.isVisible(setter, ctx) || setter.getDeclaringClass().isAnonymousClass()) {
                return;
            }
            if (!Modifier.isPublic(setter.getModifiers())) {
                setter.setAccessible(true);
            }
            this.acceptMethod(setter, OperationMode.SET);
            this.writable = true;
        } else if (this.isVisible(field, ctx) && !field.getDeclaringClass().isAnonymousClass()) {
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            this.acceptField(field, OperationMode.SET);
            this.writable = true;
        }
    }

    private boolean isVisible(Field field, JsonbContext ctx) {
        if (field == null) {
            return false;
        }
        return this.isVisible(strategy -> strategy.isVisible(field), field.getDeclaringClass(), ctx).orElseGet(() -> Modifier.isPublic(field.getModifiers()));
    }

    private boolean isVisible(Method method, JsonbContext ctx) {
        if (method == null || Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return this.isVisible(strategy -> strategy.isVisible(method), method.getDeclaringClass(), ctx).orElseGet(() -> Modifier.isPublic(method.getModifiers()));
    }

    private Optional<Boolean> isVisible(Function<PropertyVisibilityStrategy, Boolean> visibilityCheckFunction, Class<?> declaringClass, JsonbContext ctx) {
        Optional<PropertyVisibilityStrategy> classLevelStrategy = ctx.getAnnotationIntrospector().getPropertyVisibilityStrategy(declaringClass);
        Optional<PropertyVisibilityStrategy> strategy = Optional.ofNullable(classLevelStrategy.orElseGet(() -> ctx.getConfigProperties().getPropertyVisibilityStrategy()));
        return strategy.map(visibilityCheckFunction);
    }

    protected abstract void acceptMethod(Method var1, OperationMode var2);

    protected abstract void acceptField(Field var1, OperationMode var2);

    abstract void setValue(Object var1, Object var2);

    abstract Object getValue(Object var1);

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public static enum OperationMode {
        GET,
        SET;

    }
}

