/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.model.customization;

import org.eclipse.yasson.internal.adapter.AdapterBinding;
import org.eclipse.yasson.internal.adapter.DeserializerBinding;
import org.eclipse.yasson.internal.adapter.SerializerBinding;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;
import org.eclipse.yasson.model.customization.CustomizationBuilder;

public abstract class Customization {
    private final AdapterBinding adapterBinding;
    private final SerializerBinding serializerBinding;
    private final DeserializerBinding deserializerBinding;
    private final boolean nillable;

    public Customization(CustomizationBuilder builder) {
        this.nillable = builder.isNillable();
        this.adapterBinding = builder.getAdapterInfo();
        this.serializerBinding = builder.getSerializerBinding();
        this.deserializerBinding = builder.getDeserializerBinding();
    }

    public Customization(Customization other) {
        this.nillable = other.isNillable();
        this.adapterBinding = other.getAdapterBinding();
        this.serializerBinding = other.getSerializerBinding();
        this.deserializerBinding = other.getDeserializerBinding();
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public AdapterBinding getAdapterBinding() {
        return this.adapterBinding;
    }

    public SerializerBinding getSerializerBinding() {
        return this.serializerBinding;
    }

    public DeserializerBinding getDeserializerBinding() {
        return this.deserializerBinding;
    }

    public abstract JsonbNumberFormatter getSerializeNumberFormatter();

    public abstract JsonbNumberFormatter getDeserializeNumberFormatter();

    public abstract JsonbDateFormatter getSerializeDateFormatter();

    public abstract JsonbDateFormatter getDeserializeDateFormatter();

    public abstract boolean isReadTransient();

    public abstract boolean isWriteTransient();
}

