/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.txmgr.narayana;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.XAResource;
import org.ehcache.transactions.xa.txmgr.XAResourceRegistry;
import org.ehcache.transactions.xa.txmgr.narayana.EhcacheXaResourceRecoveryHelper;

public class NarayanaXAResourceRegistry
implements XAResourceRegistry {
    private final ConcurrentMap<String, EhcacheXaResourceRecoveryHelper> recoveryHelpers = new ConcurrentHashMap<String, EhcacheXaResourceRecoveryHelper>();

    @Override
    public void registerXAResource(String uniqueName, XAResource xaResource) {
        EhcacheXaResourceRecoveryHelper recoveryHelper = (EhcacheXaResourceRecoveryHelper)this.recoveryHelpers.get(uniqueName);
        if (recoveryHelper == null) {
            recoveryHelper = new EhcacheXaResourceRecoveryHelper(xaResource);
            EhcacheXaResourceRecoveryHelper previous = this.recoveryHelpers.putIfAbsent(uniqueName, recoveryHelper);
            if (previous == null) {
                XARecoveryModule.getRegisteredXARecoveryModule().addXAResourceRecoveryHelper((XAResourceRecoveryHelper)recoveryHelper);
            } else {
                previous.addXAResource(xaResource);
            }
        } else {
            recoveryHelper.addXAResource(xaResource);
        }
    }

    @Override
    public void unregisterXAResource(String uniqueName, XAResource xaResource) {
        EhcacheXaResourceRecoveryHelper recoveryHelper = (EhcacheXaResourceRecoveryHelper)this.recoveryHelpers.get(uniqueName);
        if (recoveryHelper != null) {
            boolean found = recoveryHelper.removeXAResource(xaResource);
            if (!found) {
                throw new IllegalStateException("no XAResource " + xaResource + " found in EhcacheXaResourceRecoveryHelper with name " + uniqueName);
            }
            if (recoveryHelper.isEmpty()) {
                XARecoveryModule.getRegisteredXARecoveryModule().removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)this.recoveryHelpers.remove(uniqueName));
            }
        } else {
            throw new IllegalStateException("no XAResourceProducer registered with name " + uniqueName);
        }
    }
}

