/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.TimeValue;

public class DeleteExpiredDataRequest
extends ActionRequest
implements ToXContentObject {
    static final String REQUESTS_PER_SECOND = "requests_per_second";
    static final String TIMEOUT = "timeout";
    static final String JOB_ID = "job_id";
    private final String jobId;
    private final Float requestsPerSecond;
    private final TimeValue timeout;

    public DeleteExpiredDataRequest() {
        this(null, null, null);
    }

    public DeleteExpiredDataRequest(String jobId, Float requestsPerSecond, TimeValue timeout) {
        this.jobId = jobId;
        this.requestsPerSecond = requestsPerSecond;
        this.timeout = timeout;
    }

    public Float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeleteExpiredDataRequest that = (DeleteExpiredDataRequest)((Object)o);
        return Objects.equals(this.requestsPerSecond, that.requestsPerSecond) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.jobId, that.jobId);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.requestsPerSecond, this.timeout, this.jobId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.jobId != null) {
            builder.field(JOB_ID, this.jobId);
        }
        if (this.requestsPerSecond != null) {
            builder.field(REQUESTS_PER_SECOND, this.requestsPerSecond);
        }
        if (this.timeout != null) {
            builder.field(TIMEOUT, this.timeout.getStringRep());
        }
        builder.endObject();
        return builder;
    }
}

