/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.client.rollup.RollupJobCaps;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RollableIndexCaps
implements ToXContentFragment {
    private static final ParseField ROLLUP_JOBS = new ParseField("rollup_jobs", new String[0]);
    public static final ConstructingObjectParser<RollableIndexCaps, String> PARSER = new ConstructingObjectParser(ROLLUP_JOBS.getPreferredName(), true, (args, indexName) -> {
        List caps = (List)args[0];
        return new RollableIndexCaps((String)indexName, caps);
    });
    private final String indexName;
    private final List<RollupJobCaps> jobCaps;

    RollableIndexCaps(String indexName, List<RollupJobCaps> caps) {
        this.indexName = indexName;
        this.jobCaps = Collections.unmodifiableList(Objects.requireNonNull(caps).stream().sorted(Comparator.comparing(RollupJobCaps::getJobID)).collect(Collectors.toList()));
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<RollupJobCaps> getJobCaps() {
        return this.jobCaps;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.indexName);
        builder.field(ROLLUP_JOBS.getPreferredName(), this.jobCaps);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollableIndexCaps that = (RollableIndexCaps)other;
        return Objects.equals(this.jobCaps, that.jobCaps) && Objects.equals(this.indexName, that.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.jobCaps, this.indexName);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, name) -> (RollupJobCaps)RollupJobCaps.PARSER.parse(p, null), ROLLUP_JOBS);
    }
}

