/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.core.Nullable;

public final class GetServiceAccountsRequest
implements Validatable {
    @Nullable
    private final String namespace;
    @Nullable
    private final String serviceName;

    public GetServiceAccountsRequest(@Nullable String namespace, @Nullable String serviceName) {
        this.namespace = namespace;
        this.serviceName = serviceName;
    }

    public GetServiceAccountsRequest(String namespace) {
        this(namespace, null);
    }

    public GetServiceAccountsRequest() {
        this(null, null);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.namespace == null && this.serviceName != null) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("cannot specify service-name without namespace");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountsRequest that = (GetServiceAccountsRequest)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.serviceName, that.serviceName);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.serviceName);
    }
}

