/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.client.security.TemplateRoleName;
import org.elasticsearch.client.security.support.expressiondsl.RoleMapperExpression;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;

public final class PutRoleMappingRequest
implements Validatable,
ToXContentObject {
    private final String name;
    private final boolean enabled;
    private final List<String> roles;
    private final List<TemplateRoleName> roleTemplates;
    private final RoleMapperExpression rules;
    private final Map<String, Object> metadata;
    private final RefreshPolicy refreshPolicy;

    @Deprecated
    public PutRoleMappingRequest(String name, boolean enabled, List<String> roles, RoleMapperExpression rules, @Nullable Map<String, Object> metadata, @Nullable RefreshPolicy refreshPolicy) {
        this(name, enabled, roles, Collections.emptyList(), rules, metadata, refreshPolicy);
    }

    public PutRoleMappingRequest(String name, boolean enabled, List<String> roles, List<TemplateRoleName> templates, RoleMapperExpression rules, @Nullable Map<String, Object> metadata, @Nullable RefreshPolicy refreshPolicy) {
        if (!Strings.hasText((String)name)) {
            throw new IllegalArgumentException("role-mapping name is missing");
        }
        this.name = name;
        this.enabled = enabled;
        this.roles = Collections.unmodifiableList(Objects.requireNonNull(roles, "role-mapping roles cannot be null"));
        this.roleTemplates = Collections.unmodifiableList(Objects.requireNonNull(templates, "role-mapping role_templates cannot be null"));
        if (this.roles.isEmpty() && this.roleTemplates.isEmpty()) {
            throw new IllegalArgumentException("in a role-mapping, one of roles or role_templates is required");
        }
        if (!this.roles.isEmpty() && !this.roleTemplates.isEmpty()) {
            throw new IllegalArgumentException("in a role-mapping, cannot specify both roles and role_templates");
        }
        this.rules = Objects.requireNonNull(rules, "role-mapping rules are missing");
        this.metadata = metadata == null ? Collections.emptyMap() : metadata;
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<TemplateRoleName> getRoleTemplates() {
        return this.roleTemplates;
    }

    public RoleMapperExpression getRules() {
        return this.rules;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.enabled, this.refreshPolicy, this.roles, this.roleTemplates, this.rules, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PutRoleMappingRequest other = (PutRoleMappingRequest)obj;
        return this.enabled == other.enabled && this.refreshPolicy == other.refreshPolicy && Objects.equals(this.name, other.name) && Objects.equals(this.roles, other.roles) && Objects.equals(this.roleTemplates, other.roleTemplates) && Objects.equals(this.rules, other.rules) && Objects.equals(this.metadata, other.metadata);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("enabled", this.enabled);
        builder.field("roles", this.roles);
        builder.field("role_templates", this.roleTemplates);
        builder.field("rules", (ToXContent)this.rules);
        builder.field("metadata", this.metadata);
        return builder.endObject();
    }
}

