/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.rollup.DeleteRollupJobRequest;
import org.elasticsearch.client.rollup.GetRollupCapsRequest;
import org.elasticsearch.client.rollup.GetRollupIndexCapsRequest;
import org.elasticsearch.client.rollup.GetRollupJobRequest;
import org.elasticsearch.client.rollup.PutRollupJobRequest;
import org.elasticsearch.client.rollup.StartRollupJobRequest;
import org.elasticsearch.client.rollup.StopRollupJobRequest;
import org.elasticsearch.xcontent.ToXContent;

final class RollupRequestConverters {
    private RollupRequestConverters() {
    }

    static Request putJob(PutRollupJobRequest putRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(putRollupJobRequest.getConfig().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)putRollupJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request startJob(StartRollupJobRequest startRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(startRollupJobRequest.getJobId()).addPathPartAsIs("_start").build();
        return new Request("POST", endpoint);
    }

    static Request stopJob(StopRollupJobRequest stopRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(stopRollupJobRequest.getJobId()).addPathPartAsIs("_stop").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(stopRollupJobRequest.timeout());
        if (stopRollupJobRequest.waitForCompletion() != null) {
            parameters.withWaitForCompletion(stopRollupJobRequest.waitForCompletion());
        }
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request getJob(GetRollupJobRequest getRollupJobRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(getRollupJobRequest.getJobId()).build();
        return new Request("GET", endpoint);
    }

    static Request deleteJob(DeleteRollupJobRequest deleteRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "job").addPathPart(deleteRollupJobRequest.getId()).build();
        return new Request("DELETE", endpoint);
    }

    static Request search(SearchRequest request) throws IOException {
        if (request.types().length > 0) {
            ValidationException ve = new ValidationException();
            ve.addValidationError("types are not allowed in rollup search");
            throw ve;
        }
        return RequestConverters.search(request, "_rollup_search");
    }

    static Request getRollupCaps(GetRollupCapsRequest getRollupCapsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_rollup", "data").addPathPart(getRollupCapsRequest.getIndexPattern()).build();
        return new Request("GET", endpoint);
    }

    static Request getRollupIndexCaps(GetRollupIndexCapsRequest getRollupIndexCapsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(getRollupIndexCapsRequest.indices()).addPathPartAsIs("_rollup", "data").build();
        return new Request("GET", endpoint);
    }
}

