/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.QueryConfig;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DataFrameAnalyticsSource
implements ToXContentObject {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField _SOURCE = new ParseField("_source", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("data_frame_analytics_source", true, () -> new Builder());
    private final String[] index;
    private final QueryConfig queryConfig;
    private final FetchSourceContext sourceFiltering;
    private final Map<String, Object> runtimeMappings;

    public static DataFrameAnalyticsSource fromXContent(XContentParser parser) {
        return ((Builder)PARSER.apply(parser, null)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private DataFrameAnalyticsSource(String[] index, @Nullable QueryConfig queryConfig, @Nullable FetchSourceContext sourceFiltering, @Nullable Map<String, Object> runtimeMappings) {
        this.index = Objects.requireNonNull(index);
        this.queryConfig = queryConfig;
        this.sourceFiltering = sourceFiltering;
        this.runtimeMappings = runtimeMappings;
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public FetchSourceContext getSourceFiltering() {
        return this.sourceFiltering;
    }

    public Map<String, Object> getRuntimeMappings() {
        return this.runtimeMappings;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), (Object)this.index);
        if (this.queryConfig != null) {
            builder.field(QUERY.getPreferredName(), (ToXContent)this.queryConfig.getQuery());
        }
        if (this.sourceFiltering != null) {
            builder.field(_SOURCE.getPreferredName(), (ToXContent)this.sourceFiltering);
        }
        if (this.runtimeMappings != null) {
            builder.field(SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD.getPreferredName(), this.runtimeMappings);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsSource other = (DataFrameAnalyticsSource)o;
        return Arrays.equals(this.index, other.index) && Objects.equals(this.queryConfig, other.queryConfig) && Objects.equals(this.sourceFiltering, other.sourceFiltering) && Objects.equals(this.runtimeMappings, other.runtimeMappings);
    }

    public int hashCode() {
        return Objects.hash(Arrays.asList(this.index), this.queryConfig, this.sourceFiltering, this.runtimeMappings);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareStringArray(Builder::setIndex, INDEX);
        PARSER.declareObject(Builder::setQueryConfig, (p, c) -> QueryConfig.fromXContent(p), QUERY);
        PARSER.declareField(Builder::setSourceFiltering, (p, c) -> FetchSourceContext.fromXContent((XContentParser)p), _SOURCE, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        PARSER.declareObject(Builder::setRuntimeMappings, (p, c) -> p.map(), SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD);
    }

    public static class Builder {
        private String[] index;
        private QueryConfig queryConfig;
        private FetchSourceContext sourceFiltering;
        private Map<String, Object> runtimeMappings;

        private Builder() {
        }

        public Builder setIndex(String ... index) {
            this.index = index;
            return this;
        }

        public Builder setIndex(List<String> index) {
            this.index = index.toArray(new String[0]);
            return this;
        }

        public Builder setQueryConfig(QueryConfig queryConfig) {
            this.queryConfig = queryConfig;
            return this;
        }

        public Builder setSourceFiltering(FetchSourceContext sourceFiltering) {
            this.sourceFiltering = sourceFiltering;
            return this;
        }

        public Builder setRuntimeMappings(Map<String, Object> runtimeMappings) {
            this.runtimeMappings = runtimeMappings;
            return this;
        }

        public DataFrameAnalyticsSource build() {
            return new DataFrameAnalyticsSource(this.index, this.queryConfig, this.sourceFiltering, this.runtimeMappings);
        }
    }
}

