/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.stats.common;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MemoryUsage
implements ToXContentObject {
    static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    static final ParseField PEAK_USAGE_BYTES = new ParseField("peak_usage_bytes", new String[0]);
    static final ParseField STATUS = new ParseField("status", new String[0]);
    static final ParseField MEMORY_REESTIMATE_BYTES = new ParseField("memory_reestimate_bytes", new String[0]);
    public static final ConstructingObjectParser<MemoryUsage, Void> PARSER = new ConstructingObjectParser("analytics_memory_usage", true, a -> new MemoryUsage((Instant)a[0], (Long)a[1], (Status)((Object)((Object)a[2])), (Long)a[3]));
    @Nullable
    private final Instant timestamp;
    private final long peakUsageBytes;
    private final Status status;
    private final Long memoryReestimateBytes;

    public MemoryUsage(@Nullable Instant timestamp, long peakUsageBytes, Status status, @Nullable Long memoryReestimateBytes) {
        this.timestamp = timestamp == null ? null : Instant.ofEpochMilli(Objects.requireNonNull(timestamp).toEpochMilli());
        this.peakUsageBytes = peakUsageBytes;
        this.status = status;
        this.memoryReestimateBytes = memoryReestimateBytes;
    }

    @Nullable
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getPeakUsageBytes() {
        return this.peakUsageBytes;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getMemoryReestimateBytes() {
        return this.memoryReestimateBytes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.timestamp != null) {
            builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        }
        builder.field(PEAK_USAGE_BYTES.getPreferredName(), this.peakUsageBytes);
        builder.field(STATUS.getPreferredName(), (Enum)this.status);
        if (this.memoryReestimateBytes != null) {
            builder.field(MEMORY_REESTIMATE_BYTES.getPreferredName(), this.memoryReestimateBytes);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryUsage other = (MemoryUsage)o;
        return Objects.equals(this.timestamp, other.timestamp) && this.peakUsageBytes == other.peakUsageBytes && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.memoryReestimateBytes, other.memoryReestimateBytes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.peakUsageBytes, this.status, this.memoryReestimateBytes});
    }

    public String toString() {
        return new ToStringBuilder(this.getClass()).add(TIMESTAMP.getPreferredName(), this.timestamp == null ? null : Long.valueOf(this.timestamp.getEpochSecond())).add(PEAK_USAGE_BYTES.getPreferredName(), (Object)this.peakUsageBytes).add(STATUS.getPreferredName(), (Object)this.status).add(MEMORY_REESTIMATE_BYTES.getPreferredName(), (Object)this.memoryReestimateBytes).toString();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PEAK_USAGE_BYTES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Status::fromString, STATUS);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MEMORY_REESTIMATE_BYTES);
    }

    public static enum Status {
        OK,
        HARD_LIMIT;


        public static Status fromString(String value) {
            return Status.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

