/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.support;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class ApiKey {
    private final String name;
    private final String id;
    private final Instant creation;
    private final Instant expiration;
    private final boolean invalidated;
    private final String username;
    private final String realm;
    private final Map<String, Object> metadata;
    @Nullable
    private final Object[] sortValues;
    static final ConstructingObjectParser<ApiKey, Void> PARSER = new ConstructingObjectParser("api_key", args -> {
        List arg8;
        Object[] sortValues = args[8] == null ? null : ((arg8 = (List)args[8]).isEmpty() ? null : arg8.toArray());
        return new ApiKey((String)args[0], (String)args[1], Instant.ofEpochMilli((Long)args[2]), args[3] == null ? null : Instant.ofEpochMilli((Long)args[3]), (Boolean)args[4], (String)args[5], (String)args[6], (Map)args[7], sortValues);
    });

    public ApiKey(String name, String id, Instant creation, Instant expiration, boolean invalidated, String username, String realm, Map<String, Object> metadata) {
        this(name, id, creation, expiration, invalidated, username, realm, metadata, null);
    }

    public ApiKey(String name, String id, Instant creation, Instant expiration, boolean invalidated, String username, String realm, Map<String, Object> metadata, @Nullable Object[] sortValues) {
        this.name = name;
        this.id = id;
        this.creation = Instant.ofEpochMilli(creation.toEpochMilli());
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
        this.invalidated = invalidated;
        this.username = username;
        this.realm = realm;
        this.metadata = metadata;
        this.sortValues = sortValues;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Object[] getSortValues() {
        return this.sortValues;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.creation, this.expiration, this.invalidated, this.username, this.realm, this.metadata, Arrays.hashCode(this.sortValues));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKey other = (ApiKey)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.creation, other.creation) && Objects.equals(this.expiration, other.expiration) && Objects.equals(this.invalidated, other.invalidated) && Objects.equals(this.username, other.username) && Objects.equals(this.realm, other.realm) && Objects.equals(this.metadata, other.metadata) && Arrays.equals(this.sortValues, other.sortValues);
    }

    public static ApiKey fromXContent(XContentParser parser) throws IOException {
        return (ApiKey)PARSER.parse(parser, null);
    }

    public String toString() {
        return "ApiKey [name=" + this.name + ", id=" + this.id + ", creation=" + this.creation + ", expiration=" + this.expiration + ", invalidated=" + this.invalidated + ", username=" + this.username + ", realm=" + this.realm + ", _sort=" + Arrays.toString(this.sortValues) + "]";
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.textOrNull(), new ParseField("name", new String[0]), ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("creation", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("invalidated", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("realm", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.objectText(), new ParseField("_sort", new String[0]));
    }
}

