/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.Strings;

public class GetRollupIndexCapsRequest
implements Validatable {
    private String[] indices;
    private IndicesOptions options;

    public GetRollupIndexCapsRequest(String ... indices) {
        this(indices, IndicesOptions.STRICT_EXPAND_OPEN_FORBID_CLOSED);
    }

    public GetRollupIndexCapsRequest(String[] indices, IndicesOptions options) {
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("[indices] must not be null or empty");
        }
        for (String index : indices) {
            if (!Strings.isNullOrEmpty((String)index)) continue;
            throw new IllegalArgumentException("[index] must not be null or empty");
        }
        this.indices = indices;
        this.options = Objects.requireNonNull(options);
    }

    public IndicesOptions indicesOptions() {
        return this.options;
    }

    public String[] indices() {
        return this.indices;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.options);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRollupIndexCapsRequest other = (GetRollupIndexCapsRequest)obj;
        return Arrays.equals(this.indices, other.indices) && Objects.equals(this.options, other.options);
    }
}

