/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.XContentParser;

public final class DeletePrivilegesResponse {
    private final String application;
    private final List<String> privileges;

    DeletePrivilegesResponse(String application, List<String> privileges) {
        this.application = Objects.requireNonNull(application, "application is required");
        this.privileges = Objects.requireNonNull(privileges, "privileges are required");
    }

    public String getApplication() {
        return this.application;
    }

    public boolean isFound(String privilege) {
        return this.privileges.contains(privilege);
    }

    public static DeletePrivilegesResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        String application = parser.currentName();
        ArrayList<String> foundAndDeletedPrivileges = new ArrayList<String>();
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String privilege = parser.currentName();
                token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) continue;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token != XContentParser.Token.VALUE_BOOLEAN || !"found".equals(currentFieldName) || !parser.booleanValue()) continue;
                    foundAndDeletedPrivileges.add(privilege);
                }
            }
        }
        return new DeletePrivilegesResponse(application, foundAndDeletedPrivileges);
    }
}

