/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.RetentionPolicyConfig;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TimeRetentionPolicyConfig
implements RetentionPolicyConfig {
    public static final String NAME = "time";
    private static final ParseField FIELD = new ParseField("field", new String[0]);
    private static final ParseField MAX_AGE = new ParseField("max_age", new String[0]);
    private final String field;
    private final TimeValue maxAge;
    private static final ConstructingObjectParser<TimeRetentionPolicyConfig, Void> PARSER = new ConstructingObjectParser("time_retention_policy_config", true, args -> new TimeRetentionPolicyConfig((String)args[0], args[1] != null ? (TimeValue)args[1] : TimeValue.ZERO));

    public static TimeRetentionPolicyConfig fromXContent(XContentParser parser) {
        return (TimeRetentionPolicyConfig)PARSER.apply(parser, null);
    }

    TimeRetentionPolicyConfig(String field, TimeValue maxAge) {
        this.field = field;
        this.maxAge = maxAge;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(MAX_AGE.getPreferredName(), this.maxAge.getStringRep());
        builder.endObject();
        return builder;
    }

    public String getField() {
        return this.field;
    }

    public TimeValue getMaxAge() {
        return this.maxAge;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeRetentionPolicyConfig that = (TimeRetentionPolicyConfig)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.maxAge, that.maxAge);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.maxAge);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MAX_AGE.getPreferredName()), MAX_AGE, ObjectParser.ValueType.STRING);
    }

    public static class Builder {
        private String field;
        private TimeValue maxAge;

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setMaxAge(TimeValue maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public TimeRetentionPolicyConfig build() {
            return new TimeRetentionPolicyConfig(this.field, this.maxAge);
        }
    }
}

