/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.dataframe.transforms.pivot.SingleGroupSource;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class HistogramGroupSource
extends SingleGroupSource
implements ToXContentObject {
    protected static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    private static final ConstructingObjectParser<HistogramGroupSource, Void> PARSER = new ConstructingObjectParser("histogram_group_source", true, args -> new HistogramGroupSource((String)args[0], (Double)args[1]));
    private final double interval;

    public static HistogramGroupSource fromXContent(XContentParser parser) {
        return (HistogramGroupSource)PARSER.apply(parser, null);
    }

    HistogramGroupSource(String field, double interval) {
        super(field);
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be greater than 0.");
        }
        this.interval = interval;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.HISTOGRAM;
    }

    public double getInterval() {
        return this.interval;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        builder.field(INTERVAL.getPreferredName(), this.interval);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HistogramGroupSource that = (HistogramGroupSource)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.interval, that.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.interval);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), INTERVAL);
    }

    public static class Builder {
        private String field;
        private double interval;

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setInterval(double interval) {
            this.interval = interval;
            return this;
        }

        public HistogramGroupSource build() {
            return new HistogramGroupSource(this.field, this.interval);
        }
    }
}

