/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.client.ml.job.config.FilterRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class RuleScope
implements ToXContentObject {
    private static final DeprecationHandler DEPRECATION_HANDLER = new DeprecationHandler(){

        public void usedDeprecatedName(String usedName, String modernName) {
        }

        public void usedDeprecatedField(String usedName, String replacedWith) {
        }
    };
    private final Map<String, FilterRef> scope;

    public static ContextParser<Void, RuleScope> parser() {
        return (p, c) -> {
            Map unparsedScope = p.map();
            if (unparsedScope.isEmpty()) {
                return new RuleScope();
            }
            HashMap<String, FilterRef> scope = new HashMap<String, FilterRef>();
            for (Map.Entry entry : unparsedScope.entrySet()) {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                try {
                    Map value = (Map)entry.getValue();
                    builder.map(value);
                    XContentParser scopeParser = XContentFactory.xContent((XContentType)builder.contentType()).createParser(NamedXContentRegistry.EMPTY, DEPRECATION_HANDLER, Strings.toString((XContentBuilder)builder));
                    try {
                        scope.put((String)entry.getKey(), (FilterRef)FilterRef.PARSER.parse(scopeParser, null));
                    }
                    finally {
                        if (scopeParser == null) continue;
                        scopeParser.close();
                    }
                }
                finally {
                    if (builder == null) continue;
                    builder.close();
                }
            }
            return new RuleScope(scope);
        };
    }

    public RuleScope() {
        this.scope = Collections.emptyMap();
    }

    public RuleScope(Map<String, FilterRef> scope) {
        this.scope = Collections.unmodifiableMap(scope);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.scope);
    }

    public boolean isEmpty() {
        return this.scope.isEmpty();
    }

    public Set<String> getReferencedFilters() {
        return this.scope.values().stream().map(FilterRef::getFilterId).collect(Collectors.toSet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleScope)) {
            return false;
        }
        RuleScope other = (RuleScope)obj;
        return Objects.equals(this.scope, other.scope);
    }

    public int hashCode() {
        return Objects.hash(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, FilterRef> scope = new HashMap<String, FilterRef>();

        public Builder() {
        }

        public Builder(RuleScope otherScope) {
            this.scope = new HashMap<String, FilterRef>(otherScope.scope);
        }

        public Builder exclude(String field, String filterId) {
            this.scope.put(field, new FilterRef(filterId, FilterRef.FilterType.EXCLUDE));
            return this;
        }

        public Builder include(String field, String filterId) {
            this.scope.put(field, new FilterRef(filterId, FilterRef.FilterType.INCLUDE));
            return this;
        }

        public RuleScope build() {
            return new RuleScope(this.scope);
        }
    }
}

