/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.logging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.maven.plugin.logging.Log;
import org.eluder.coveralls.maven.plugin.domain.Job;
import org.eluder.coveralls.maven.plugin.logging.Logger;

public class JobLogger
implements Logger {
    private static final int ABBREV = 7;
    private final Job job;
    private final ObjectMapper jsonMapper;

    public JobLogger(Job job) {
        this(job, null);
    }

    public JobLogger(Job job, ObjectMapper jsonMapper) {
        if (job == null) {
            throw new IllegalArgumentException("job must be defined");
        }
        this.job = job;
        this.jsonMapper = jsonMapper != null ? jsonMapper : this.createDefaultJsonMapper();
    }

    @Override
    public Logger.Position getPosition() {
        return Logger.Position.BEFORE;
    }

    @Override
    public void log(Log log) {
        StringBuilder starting = new StringBuilder("Starting Coveralls job");
        if (this.job.getServiceName() != null) {
            starting.append(" for " + this.job.getServiceName());
            if (this.job.getServiceJobId() != null) {
                starting.append(" (" + this.job.getServiceJobId() + ")");
            } else if (this.job.getServiceBuildNumber() != null) {
                starting.append(" (" + this.job.getServiceBuildNumber());
                if (this.job.getServiceBuildUrl() != null) {
                    starting.append(" / " + this.job.getServiceBuildUrl());
                }
                starting.append(")");
            }
        }
        if (this.job.isDryRun()) {
            starting.append(" in dry run mode");
        }
        log.info((CharSequence)starting.toString());
        if (this.job.getRepoToken() != null) {
            log.info((CharSequence)"Using repository token <secret>");
        }
        if (this.job.getGit() != null) {
            String commit = this.job.getGit().getHead().getId();
            String branch = this.job.getBranch() != null ? this.job.getBranch() : this.job.getGit().getBranch();
            log.info((CharSequence)("Git commit " + commit.substring(0, 7) + " in " + branch));
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((CharSequence)("Complete Job description:\n" + this.jsonMapper.writeValueAsString((Object)this.job)));
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private ObjectMapper createDefaultJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return mapper;
    }
}

