/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.assured;

import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.everrest.assured.util.AvailablePortFinder;
import org.everrest.assured.util.IoUtil;
import org.everrest.core.DependencySupplier;
import org.everrest.core.ObjectFactory;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.RequestHandlerImpl;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.servlet.EverrestInitializedListener;
import org.everrest.core.servlet.EverrestServlet;
import org.everrest.core.tools.ResourceLauncher;
import org.everrest.groovy.BaseResourceId;
import org.everrest.groovy.GroovyResourcePublisher;
import org.everrest.groovy.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpServer.class);
    public static final String UNSECURE_REST = "/rest";
    public static final String UNSECURE_PATH_SPEC = "/rest/*";
    public static final String SECURE_PATH = "/private";
    public static final String SECURE_REST = "/rest/private";
    public static final String SECURE_PATH_SPEC = "/rest/private/*";
    protected ServletContextHandler context;
    protected final int port;
    protected final Server server;
    public static final String ADMIN_USER_NAME = "cldadmin";
    public static final String ADMIN_USER_PASSWORD = "tomcat";
    public static final String MANAGER_USER_NAME = "cldmanager";
    public static final String MANAGER_USER_PASSWORD = "manager";
    public static final String UNAUTHORIZED_USER = "user";

    public JettyHttpServer() {
        this(AvailablePortFinder.getNextAvailable(3000));
    }

    public JettyHttpServer(int port) {
        this.port = port;
        this.server = new Server(port);
        this.context = null;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        RequestLogHandler handler = new RequestLogHandler();
        if (this.context == null) {
            this.context = new ServletContextHandler((HandlerContainer)handler, "/", 1);
        }
        this.context.setEventListeners(new EventListener[]{new EverrestInitializedListener()});
        ServletHolder servletHolder = new ServletHolder((Servlet)new EverrestServlet());
        this.context.addServlet(servletHolder, UNSECURE_PATH_SPEC);
        this.context.addServlet(servletHolder, SECURE_PATH_SPEC);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"cloud-admin"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec(SECURE_PATH_SPEC);
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(constraintMapping);
        HashLoginService loginService = new HashLoginService();
        loginService.putUser(ADMIN_USER_NAME, (Credential)new Password(ADMIN_USER_PASSWORD), new String[]{"cloud-admin"});
        loginService.putUser(MANAGER_USER_NAME, (Credential)new Password(MANAGER_USER_PASSWORD), new String[]{"cloud-admin"});
        securityHandler.setLoginService((LoginService)loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        this.context.setSecurityHandler((SecurityHandler)securityHandler);
        this.server.setHandler((Handler)handler);
        this.server.start();
        ResourceBinder binder = (ResourceBinder)this.context.getServletContext().getAttribute(ResourceBinder.class.getName());
        DependencySupplier dependencies = (DependencySupplier)this.context.getServletContext().getAttribute(DependencySupplier.class.getName());
        GroovyResourcePublisher groovyPublisher = new GroovyResourcePublisher(binder, dependencies);
        this.context.getServletContext().setAttribute(GroovyResourcePublisher.class.getName(), (Object)groovyPublisher);
    }

    public void stop() throws Exception {
        this.context = null;
        this.server.stop();
    }

    public void setFactories(List<ObjectFactory<AbstractResourceDescriptor>> factories) {
        ResourceBinder binder = (ResourceBinder)this.context.getServletContext().getAttribute(ResourceBinder.class.getName());
        for (ObjectFactory<AbstractResourceDescriptor> resource : factories) {
            binder.addResource(resource);
        }
    }

    public void publishPerRequestGroovyScript(String resourcePath, String name) {
        GroovyResourcePublisher groovyPublisher = (GroovyResourcePublisher)this.context.getServletContext().getAttribute(GroovyResourcePublisher.class.getName());
        BaseResourceId publishedResourceId = new BaseResourceId(name);
        groovyPublisher.publishPerRequest(IoUtil.getResource(resourcePath), (ResourceId)publishedResourceId, null, null, null);
    }

    public ServletContextHandler getContext() {
        return this.context;
    }

    public void resetFactories() {
        ResourceBinder binder = (ResourceBinder)this.context.getServletContext().getAttribute(ResourceBinder.class.getName());
        ((ResourceBinderImpl)binder).clear();
    }

    public ResourceLauncher getResourceLauncher() {
        ResourceBinder binder = (ResourceBinder)this.context.getServletContext().getAttribute(ResourceBinder.class.getName());
        DependencySupplier suppier = (DependencySupplier)this.context.getServletContext().getAttribute(DependencySupplier.class.getName());
        ApplicationProviderBinder providerBinder = (ApplicationProviderBinder)this.context.getServletContext().getAttribute(ApplicationProviderBinder.class.getName());
        return new ResourceLauncher((RequestHandler)new RequestHandlerImpl(new RequestDispatcher(binder), (ProviderBinder)providerBinder, suppier, new EverrestConfiguration()));
    }
}

