/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.assured;

import com.jayway.restassured.RestAssured;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.everrest.assured.JettyHttpServer;
import org.everrest.assured.TestResourceFactory;
import org.everrest.core.Filter;
import org.everrest.core.ObjectFactory;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

public class EverrestJetty
implements ITestListener,
IInvokedMethodListener {
    public static final String JETTY_PORT = "jetty-port";
    public static final String JETTY_SERVER = "jetty-server";
    private static final Logger LOG = LoggerFactory.getLogger(EverrestJetty.class);
    private JettyHttpServer httpServer;

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.httpServer != null && this.hasEverrestJettyListener(method.getTestMethod().getInstance().getClass())) {
            List<ObjectFactory<AbstractResourceDescriptor>> factories = this.getResourcesFactories(method.getTestMethod());
            this.httpServer.resetFactories();
        }
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.httpServer != null && this.hasEverrestJettyListener(method.getTestMethod().getInstance().getClass())) {
            List<ObjectFactory<AbstractResourceDescriptor>> factories = this.getResourcesFactories(method.getTestMethod());
            this.httpServer.resetFactories();
            this.httpServer.setFactories(factories);
        }
    }

    public void onFinish(ITestContext context) {
        JettyHttpServer httpServer = (JettyHttpServer)context.getAttribute(JETTY_SERVER);
        if (httpServer != null) {
            try {
                httpServer.stop();
                httpServer = null;
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void onStart(ITestContext context) {
        ITestNGMethod[] allTestMethods = context.getAllTestMethods();
        if (allTestMethods == null) {
            return;
        }
        if (this.httpServer == null && this.hasEverrestJettyListenerTestHierarchy(allTestMethods)) {
            this.httpServer = new JettyHttpServer();
            context.setAttribute(JETTY_PORT, (Object)this.httpServer.getPort());
            context.setAttribute(JETTY_SERVER, (Object)this.httpServer);
            try {
                this.httpServer.start();
                this.httpServer.setExceptionMappers(this.getExceptionMappers(allTestMethods));
                RestAssured.port = this.httpServer.getPort();
                RestAssured.basePath = "/rest";
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onTestFailure(ITestResult result) {
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
    }

    private List<ObjectFactory<AbstractResourceDescriptor>> getResourcesFactories(ITestNGMethod ... testMethods) {
        ArrayList<ObjectFactory<AbstractResourceDescriptor>> factories = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
        for (ITestNGMethod testMethod : testMethods) {
            Field[] fields;
            Object instance = testMethod.getInstance();
            if (!this.hasEverrestJettyListenerTestHierarchy(instance.getClass())) continue;
            for (Field field : fields = instance.getClass().getDeclaredFields()) {
                if (!this.isRestResource(field.getType())) continue;
                factories.add(new TestResourceFactory(field.getType(), instance, field));
            }
        }
        return factories;
    }

    private List<ExceptionMapper> getExceptionMappers(ITestNGMethod ... testMethods) {
        ArrayList<ExceptionMapper> factories = new ArrayList<ExceptionMapper>();
        for (ITestNGMethod testMethod : testMethods) {
            Field[] fields;
            Object instance = testMethod.getInstance();
            if (!this.hasEverrestJettyListenerTestHierarchy(instance.getClass())) continue;
            for (Field field : fields = instance.getClass().getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(ExceptionMapper.class)) continue;
                field.setAccessible(true);
                try {
                    factories.add((ExceptionMapper)field.get(instance));
                }
                catch (IllegalAccessException e) {
                    LOG.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return factories;
    }

    private boolean hasEverrestJettyListener(Class<?> clazz) {
        Listeners listeners = clazz.getAnnotation(Listeners.class);
        if (listeners == null) {
            return false;
        }
        for (Class listenerClass : listeners.value()) {
            if (!EverrestJetty.class.isAssignableFrom(listenerClass)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEverrestJettyListenerTestHierarchy(Class<?> testClass) {
        for (Class<?> clazz = testClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!this.hasEverrestJettyListener(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEverrestJettyListenerTestHierarchy(ITestNGMethod ... testMethods) {
        for (ITestNGMethod testMethod : testMethods) {
            Object instance = testMethod.getInstance();
            if (!this.hasEverrestJettyListenerTestHierarchy(instance.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isRestResource(Class<? extends Object> resourceClass) {
        return resourceClass.isAnnotationPresent(Path.class) || resourceClass.isAnnotationPresent(Provider.class) || resourceClass.isAnnotationPresent(Filter.class);
    }
}

