/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core;

import java.lang.annotation.Annotation;
import org.everrest.core.DependencySupplier;
import org.everrest.core.FieldInjector;
import org.everrest.core.Inject;
import org.everrest.core.Parameter;

public abstract class BaseDependencySupplier
implements DependencySupplier {
    protected final Class<? extends Annotation> injectAnnotation;

    public BaseDependencySupplier(Class<? extends Annotation> injectAnnotation) {
        if (injectAnnotation == null) {
            throw new IllegalArgumentException("Inject annotation class may not be null. ");
        }
        this.injectAnnotation = injectAnnotation;
    }

    public BaseDependencySupplier() {
        this(Inject.class);
    }

    @Override
    public final Object getComponent(Parameter parameter) {
        if (parameter instanceof FieldInjector) {
            for (Annotation a : parameter.getAnnotations()) {
                if (a.annotationType() != this.injectAnnotation) continue;
                return this.getComponent(parameter.getParameterClass());
            }
            return null;
        }
        return this.getComponent(parameter.getParameterClass());
    }
}

