/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.everrest.core.impl.OutputHeadersMap;
import org.everrest.core.util.CaselessMultivaluedMap;
import org.everrest.core.util.CaselessStringWrapper;

public final class ResponseImpl
extends Response {
    private final int status;
    private final Object entity;
    private final MultivaluedMap<String, Object> headers;

    ResponseImpl(int status, Object entity, MultivaluedMap<String, Object> headers) {
        this.status = status;
        this.entity = entity;
        this.headers = headers;
    }

    public Object getEntity() {
        return this.entity;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public static final class ResponseBuilderImpl
    extends Response.ResponseBuilder {
        private static final Map<HEADERS, String> ENUM_TO_HEADER = new HashMap<HEADERS, String>();
        private static final Map<CaselessStringWrapper, HEADERS> HEADER_TO_ENUM = new HashMap<CaselessStringWrapper, HEADERS>();
        private static final int DEFAULT_HTTP_STATUS;
        private int status = DEFAULT_HTTP_STATUS;
        private Object entity;
        private MultivaluedMap<String, Object> headers = new CaselessMultivaluedMap<Object>();
        private Map<String, NewCookie> cookies = new HashMap<String, NewCookie>();

        ResponseBuilderImpl() {
        }

        private ResponseBuilderImpl(ResponseBuilderImpl other) {
            this.status = other.status;
            this.entity = other.entity;
            this.headers.putAll(other.headers);
            this.cookies.putAll(other.cookies);
        }

        public Response build() {
            OutputHeadersMap m = new OutputHeadersMap((Map<String, List<Object>>)this.headers);
            if (this.cookies.size() > 0) {
                for (NewCookie c : this.cookies.values()) {
                    m.add("Set-Cookie", c);
                }
            }
            ResponseImpl response = new ResponseImpl(this.status, this.entity, m);
            this.reset();
            return response;
        }

        private void reset() {
            this.status = DEFAULT_HTTP_STATUS;
            this.entity = null;
            this.headers.clear();
            this.cookies.clear();
        }

        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.CACHE_CONTROL), (Object)cacheControl);
            return this;
        }

        public Response.ResponseBuilder clone() {
            return new ResponseBuilderImpl(this);
        }

        public Response.ResponseBuilder contentLocation(URI location) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.CONTENT_LOCATION), (Object)location);
            return this;
        }

        public Response.ResponseBuilder cookie(NewCookie ... cookies) {
            if (cookies == null) {
                this.cookies.clear();
                this.headers.remove((Object)"Set-Cookie");
            } else {
                for (NewCookie c : cookies) {
                    this.cookies.put(c.getName(), c);
                }
            }
            return this;
        }

        public Response.ResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Response.ResponseBuilder expires(Date expires) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.EXPIRES), (Object)expires);
            return this;
        }

        public Response.ResponseBuilder header(String name, Object value) {
            CaselessStringWrapper caselessname = new CaselessStringWrapper(name);
            if (HEADER_TO_ENUM.get(caselessname) != null) {
                this.headers.putSingle((Object)name, value);
            } else if (value == null) {
                this.headers.remove((Object)name);
            } else {
                this.headers.add((Object)name, value);
            }
            return this;
        }

        public Response.ResponseBuilder language(String language) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.CONTENT_LANGUAGE), (Object)language);
            return this;
        }

        public Response.ResponseBuilder language(Locale language) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.CONTENT_LANGUAGE), (Object)language);
            return this;
        }

        public Response.ResponseBuilder lastModified(Date lastModified) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.LAST_MODIFIED), (Object)lastModified);
            return this;
        }

        public Response.ResponseBuilder location(URI location) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.LOCATION), (Object)location);
            return this;
        }

        public Response.ResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        public Response.ResponseBuilder tag(EntityTag tag) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.ETAG), (Object)tag);
            return this;
        }

        public Response.ResponseBuilder tag(String tag) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.ETAG), (Object)tag);
            return this;
        }

        public Response.ResponseBuilder type(MediaType type) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.CONTENT_TYPE), (Object)type);
            return this;
        }

        public Response.ResponseBuilder type(String type) {
            this.headers.putSingle((Object)ENUM_TO_HEADER.get((Object)HEADERS.CONTENT_TYPE), (Object)type);
            return this;
        }

        public Response.ResponseBuilder variant(Variant variant) {
            this.type(variant.getMediaType());
            this.language(variant.getLanguage());
            if (variant.getEncoding() != null) {
                this.header("Content-Encoding", variant.getEncoding());
            }
            return this;
        }

        public Response.ResponseBuilder variants(List<Variant> variants) {
            if (variants.isEmpty()) {
                return this;
            }
            boolean acceptMediaType = variants.get(0).getMediaType() != null;
            boolean acceptLanguage = variants.get(0).getLanguage() != null;
            boolean acceptEncoding = variants.get(0).getEncoding() != null;
            for (Variant v : variants) {
                acceptMediaType |= v.getMediaType() != null;
                acceptLanguage |= v.getLanguage() != null;
                acceptEncoding |= v.getEncoding() != null;
            }
            StringBuilder sb = new StringBuilder();
            if (acceptMediaType) {
                sb.append("Accept");
            }
            if (acceptLanguage) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("Accept-Language");
            }
            if (acceptEncoding) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("Accept-Encoding");
            }
            if (sb.length() > 0) {
                this.header("Vary", sb.toString());
            }
            return this;
        }

        static {
            ENUM_TO_HEADER.put(HEADERS.CACHE_CONTROL, "Cache-Control");
            ENUM_TO_HEADER.put(HEADERS.CONTENT_LANGUAGE, "Content-Language");
            ENUM_TO_HEADER.put(HEADERS.CONTENT_LOCATION, "Content-Location");
            ENUM_TO_HEADER.put(HEADERS.CONTENT_TYPE, "Content-Type");
            ENUM_TO_HEADER.put(HEADERS.CONTENT_LENGTH, "Content-Length");
            ENUM_TO_HEADER.put(HEADERS.ETAG, "ETag");
            ENUM_TO_HEADER.put(HEADERS.LAST_MODIFIED, "Last-Modified");
            ENUM_TO_HEADER.put(HEADERS.LOCATION, "Location");
            ENUM_TO_HEADER.put(HEADERS.EXPIRES, "Expires");
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Cache-Control"), HEADERS.CACHE_CONTROL);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Language"), HEADERS.CONTENT_LANGUAGE);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Location"), HEADERS.CONTENT_LOCATION);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Type"), HEADERS.CONTENT_TYPE);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Length"), HEADERS.CONTENT_LENGTH);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("ETag"), HEADERS.ETAG);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Last-Modified"), HEADERS.LAST_MODIFIED);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Location"), HEADERS.LOCATION);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Expires"), HEADERS.EXPIRES);
            DEFAULT_HTTP_STATUS = Response.Status.NO_CONTENT.getStatusCode();
        }

        private static enum HEADERS {
            CACHE_CONTROL,
            CONTENT_LANGUAGE,
            CONTENT_LOCATION,
            CONTENT_TYPE,
            CONTENT_LENGTH,
            ETAG,
            EXPIRES,
            LAST_MODIFIED,
            LOCATION;

        }
    }
}

